/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.testing.templateengine.standard.test.evaluator.field.defaultevaluators;

import org.thymeleaf.testing.templateengine.exception.TestEngineExecutionException;
import org.thymeleaf.testing.templateengine.resource.ITestResource;
import org.thymeleaf.testing.templateengine.resource.ITestResourceResolver;
import org.thymeleaf.testing.templateengine.standard.test.data.StandardTestEvaluatedField;
import org.thymeleaf.testing.templateengine.standard.test.data.StandardTestRawData;
import org.thymeleaf.testing.templateengine.standard.test.evaluator.field.IStandardTestFieldEvaluator;
import org.thymeleaf.util.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractStandardTestFieldEvaluator
implements IStandardTestFieldEvaluator {
    private final Class<?> expectedClass;

    protected AbstractStandardTestFieldEvaluator(Class<?> expectedClass) {
        Validate.notNull(expectedClass, (String)"Expected class cannot be null");
        this.expectedClass = expectedClass;
    }

    @Override
    public final Class<?> getValueClass() {
        return this.expectedClass;
    }

    @Override
    public final StandardTestEvaluatedField getValue(String executionId, StandardTestRawData data, ITestResourceResolver testResourceResolver, String fieldName, String fieldQualifier) {
        StandardTestEvaluatedField evaluation = this.getValue(executionId, data.getTestResource(), testResourceResolver, fieldName, fieldQualifier, data.getValueForFieldAndQualifier(fieldName, fieldQualifier));
        if (evaluation != null && evaluation.hasNotNullValue()) {
            Object value = evaluation.getValue();
            Class<?> valueClass = this.getValueClass();
            if (!valueClass.isAssignableFrom(value.getClass())) {
                throw new TestEngineExecutionException("A value of class \"" + value.getClass().getName() + "\" resulted from evaluation " + "of field \"" + fieldName + "\" in " + "\"" + data.getTestResource().getName() + "\", but value was expected to be of class " + "\"" + valueClass.getName() + "\"");
            }
        }
        return evaluation;
    }

    protected abstract StandardTestEvaluatedField getValue(String var1, ITestResource var2, ITestResourceResolver var3, String var4, String var5, String var6);
}

