/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.testing.templateengine.resource;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.thymeleaf.testing.templateengine.exception.TestEngineExecutionException;
import org.thymeleaf.testing.templateengine.resource.AbstractTestResource;
import org.thymeleaf.testing.templateengine.resource.ILocalTestResource;
import org.thymeleaf.testing.templateengine.resource.ITestResource;
import org.thymeleaf.testing.templateengine.resource.ITestResourceContainer;
import org.thymeleaf.testing.templateengine.resource.LocalFileTestResource;
import org.thymeleaf.util.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalFolderTestResource
extends AbstractTestResource
implements ITestResourceContainer,
ILocalTestResource {
    private final File resourceFile;
    private final String characterEncoding;

    public LocalFolderTestResource(File file, String characterEncoding) {
        super(LocalFolderTestResource.validateFile(file));
        Validate.notNull((Object)characterEncoding, (String)"Character encoding cannot be null");
        this.resourceFile = file.getAbsoluteFile();
        this.characterEncoding = characterEncoding;
        if (!this.resourceFile.isDirectory()) {
            throw new TestEngineExecutionException("Error while reading folder resource container \"" + this.resourceFile.getAbsolutePath() + "\". " + "Resource is NOT a folder.");
        }
    }

    private static String validateFile(File file) {
        Validate.notNull((Object)file, (String)"Resource file cannot be null");
        return file.getAbsolutePath();
    }

    @Override
    public File getResourceFile() {
        return this.resourceFile;
    }

    @Override
    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    @Override
    public List<ITestResource> getContainedResources() {
        File[] fileList;
        ArrayList<LocalFolderTestResource> containedResources = new ArrayList<LocalFolderTestResource>();
        for (File containedFile : fileList = this.resourceFile.listFiles()) {
            AbstractTestResource containedResource = containedFile.isDirectory() ? new LocalFolderTestResource(containedFile, this.characterEncoding) : new LocalFileTestResource(containedFile, this.characterEncoding);
            containedResources.add((LocalFolderTestResource)containedResource);
        }
        return Collections.unmodifiableList(containedResources);
    }
}

