/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.testing.templateengine.standard.test.evaluator.field.defaultevaluators;

import java.io.File;
import java.io.FileWriter;
import org.thymeleaf.testing.templateengine.exception.TestEngineExecutionException;
import org.thymeleaf.testing.templateengine.resource.FileTestResource;
import org.thymeleaf.testing.templateengine.resource.ITestResource;
import org.thymeleaf.testing.templateengine.standard.test.data.StandardTestEvaluatedField;
import org.thymeleaf.testing.templateengine.standard.test.evaluator.field.defaultevaluators.AbstractStandardTestFieldEvaluator;
import org.thymeleaf.util.Validate;

public abstract class AbstractTempFileResourceStandardTestFieldEvaluator
extends AbstractStandardTestFieldEvaluator {
    protected AbstractTempFileResourceStandardTestFieldEvaluator() {
        super(ITestResource.class);
    }

    protected final StandardTestEvaluatedField getValue(String executionId, String documentName, String fieldName, String fieldQualifier, String fieldValue) {
        if (fieldValue == null || fieldValue.trim().equals("")) {
            return StandardTestEvaluatedField.forNoValue();
        }
        return StandardTestEvaluatedField.forSpecifiedValue(this.createResource(executionId, this.getFileSuffix(), fieldValue));
    }

    protected ITestResource createResource(String executionId, String fileSuffix, String contents) {
        Validate.notNull((Object)executionId, (String)"Execution ID cannot be null");
        Validate.notNull((Object)fileSuffix, (String)"File suffix cannot be null");
        Validate.notNull((Object)contents, (String)"Contents cannot be null");
        try {
            String prefix = "thymeleaf-testing" + (executionId != null ? "-" + executionId : "") + (fileSuffix != null ? "-" + fileSuffix : "") + "-";
            File tempFile = File.createTempFile(prefix, null);
            tempFile.deleteOnExit();
            FileWriter writer = null;
            try {
                writer = new FileWriter(tempFile, false);
                writer.write(contents);
            }
            catch (Throwable t) {
                throw new TestEngineExecutionException("Could not write contents of temporary file for execution \"" + executionId + "\"", t);
            }
            finally {
                try {
                    if (writer != null) {
                        writer.close();
                    }
                }
                catch (Throwable ignored) {}
            }
            return new FileTestResource(tempFile);
        }
        catch (TestEngineExecutionException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new TestEngineExecutionException("Could not create temporary file for execution \"" + executionId + "\"", t);
        }
    }

    protected abstract String getFileSuffix();
}

