/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.testing.templateengine.standard.resolver;

import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import org.thymeleaf.testing.templateengine.exception.TestEngineExecutionException;
import org.thymeleaf.testing.templateengine.standard.resolver.AbstractStandardLocalFileTestableResolver;
import org.thymeleaf.util.ClassLoaderUtils;
import org.thymeleaf.util.Validate;

public class StandardClassPathTestableResolver
extends AbstractStandardLocalFileTestableResolver {
    protected File getFileFromTestableName(String executionId, String testableName) {
        Validate.notNull((Object)testableName, (String)"Testable name cannot be null");
        ClassLoader cl = ClassLoaderUtils.getClassLoader(StandardClassPathTestableResolver.class);
        URL url = cl.getResource(testableName);
        if (url == null) {
            throw new TestEngineExecutionException("Cannot resolve testable with name: \"" + testableName + "\"");
        }
        try {
            return new File(url.toURI());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("ClassPath folder name resulted in an unusable URL: \"" + url + "\". " + "Note that this builder cannot be used for resources contained in .jars", e);
        }
    }
}

