/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.testing.templateengine.resource;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import org.thymeleaf.testing.templateengine.resource.ITestResource;
import org.thymeleaf.util.Validate;

public class FileTestResource
implements ITestResource {
    private final File file;

    public FileTestResource(File file) {
        Validate.notNull((Object)file, (String)"Resource file cannot be null");
        this.file = file;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String read() {
        File file = this.file;
        synchronized (file) {
            String string;
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new FileReader(this.file));
                StringBuilder strBuilder = new StringBuilder();
                String line = reader.readLine();
                if (line != null) {
                    strBuilder.append(line);
                    while ((line = reader.readLine()) != null) {
                        strBuilder.append('\n');
                        strBuilder.append(line);
                    }
                }
                string = strBuilder.toString();
            }
            catch (Throwable t) {
                throw new RuntimeException("Could not read resource file \"" + this.file.getAbsolutePath() + "\"", t);
            }
            return string;
            finally {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (Throwable ignored) {}
            }
        }
    }
}

