/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.testing.templateengine.messages;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.thymeleaf.testing.templateengine.messages.ITestMessages;
import org.thymeleaf.testing.templateengine.messages.ITestMessagesForLocale;
import org.thymeleaf.testing.templateengine.messages.TestMessagesForLocale;
import org.thymeleaf.util.MessageResolutionUtils;
import org.thymeleaf.util.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestMessages
implements ITestMessages {
    private final Map<Locale, ITestMessagesForLocale> messagesByLocale = new HashMap<Locale, ITestMessagesForLocale>();

    @Override
    public Set<Locale> getLocales() {
        return this.messagesByLocale.keySet();
    }

    @Override
    public ITestMessagesForLocale getMessagesForLocale(Locale locale) {
        return this.messagesByLocale.get(locale);
    }

    public void setMessagesByLocale(Map<Locale, ITestMessagesForLocale> messages) {
        Validate.notNull(messages, (String)"Messages cannot be null");
        this.messagesByLocale.clear();
        this.messagesByLocale.putAll(messages);
    }

    public void setMessagesForLocale(Locale locale, ITestMessagesForLocale messagesForLocale) {
        Validate.notNull((Object)messagesForLocale, (String)"Messages for locale cannot be null");
        this.messagesByLocale.put(locale, messagesForLocale);
    }

    @Override
    public String computeMessage(Locale locale, String key, Object[] messageParameters) {
        Validate.notNull((Object)key, (String)"Message key cannot be null");
        String message = this.doComputeMessage(locale, key, messageParameters);
        if (message == null) {
            message = this.doComputeMessage(TestMessages.getLocaleWithLanguageCountry(locale), key, messageParameters);
        }
        if (message == null) {
            message = this.doComputeMessage(TestMessages.getLocaleWithLanguage(locale), key, messageParameters);
        }
        if (message == null) {
            message = this.doComputeMessage(null, key, messageParameters);
        }
        if (message == null) {
            message = MessageResolutionUtils.getAbsentMessageRepresentation((String)key, (Locale)locale);
        }
        return message;
    }

    private String doComputeMessage(Locale locale, String key, Object[] messageParameters) {
        Validate.notNull((Object)key, (String)"Message key cannot be null");
        ITestMessagesForLocale messagesForLocale = this.messagesByLocale.get(locale);
        if (messagesForLocale == null) {
            return null;
        }
        String messageValue = messagesForLocale.getMessageForKey(key);
        if (messageValue == null) {
            return null;
        }
        if (messageParameters == null || messageParameters.length == 0) {
            return messageValue;
        }
        MessageFormat messageFormat = new MessageFormat(messageValue, locale);
        return messageFormat.format(messageParameters);
    }

    private static Locale getLocaleWithLanguageCountry(Locale locale) {
        return new Locale(locale.getLanguage() + "_" + locale.getCountry());
    }

    private static Locale getLocaleWithLanguage(Locale locale) {
        return new Locale(locale.getLanguage());
    }

    @Override
    public ITestMessages aggregate(ITestMessages messages) {
        TestMessages newMessages = new TestMessages();
        newMessages.setMessagesByLocale(this.messagesByLocale);
        if (messages != null) {
            Set<Locale> locales = messages.getLocales();
            for (Locale locale : locales) {
                ITestMessagesForLocale messagesForLocale = messages.getMessagesForLocale(locale);
                if (messagesForLocale == null) continue;
                ITestMessagesForLocale originalMessagesForLocale = newMessages.messagesByLocale.get(locale);
                if (originalMessagesForLocale == null) {
                    originalMessagesForLocale = new TestMessagesForLocale();
                    newMessages.messagesByLocale.put(locale, originalMessagesForLocale);
                }
                newMessages.messagesByLocale.put(locale, originalMessagesForLocale.aggregate(messagesForLocale));
            }
        }
        return newMessages;
    }
}

