/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.testing.templateengine.engine.resolver;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.PatternSpec;
import org.thymeleaf.TemplateProcessingParameters;
import org.thymeleaf.exceptions.AlreadyInitializedException;
import org.thymeleaf.exceptions.NotInitializedException;
import org.thymeleaf.resourceresolver.IResourceResolver;
import org.thymeleaf.templateresolver.AlwaysValidTemplateResolutionValidity;
import org.thymeleaf.templateresolver.ITemplateResolutionValidity;
import org.thymeleaf.templateresolver.ITemplateResolver;
import org.thymeleaf.templateresolver.NonCacheableTemplateResolutionValidity;
import org.thymeleaf.templateresolver.TemplateResolution;
import org.thymeleaf.testing.templateengine.engine.TestExecutor;
import org.thymeleaf.testing.templateengine.engine.resolver.TestResourceResolver;
import org.thymeleaf.testing.templateengine.exception.TestEngineExecutionException;
import org.thymeleaf.testing.templateengine.resource.ITestResource;
import org.thymeleaf.testing.templateengine.testable.ITest;
import org.thymeleaf.util.Validate;

public class TestTemplateResolver
implements ITemplateResolver {
    public static final String TEST_TEMPLATE_CONVERSION_CHARSET = "UTF-8";
    private static final Logger logger = LoggerFactory.getLogger(TestTemplateResolver.class);
    private String name = null;
    private Integer order = null;
    private final PatternSpec resolvablePatternSpec = new PatternSpec();
    private volatile boolean initialized = false;

    protected final boolean isInitialized() {
        return this.initialized;
    }

    public final synchronized void initialize() {
        if (!this.isInitialized()) {
            if (this.name == null) {
                this.name = this.getClass().getName();
            }
            logger.info("[THYMELEAF] INITIALIZING TEMPLATE RESOLVER: " + this.name);
            this.resolvablePatternSpec.initialize();
            this.initializeSpecific();
            this.initialized = true;
            logger.info("[THYMELEAF] TEMPLATE RESOLVER INITIALIZED OK");
        }
    }

    protected void initializeSpecific() {
    }

    protected final void checkNotInitialized() {
        if (this.isInitialized()) {
            throw new AlreadyInitializedException("Cannot modify template resolver when it has already been initialized");
        }
    }

    protected final void checkInitialized() {
        if (!this.isInitialized()) {
            throw new NotInitializedException("Template Resolver has not been initialized");
        }
    }

    public String getName() {
        this.checkInitialized();
        return this.name;
    }

    protected String unsafeGetName() {
        return this.name;
    }

    public void setName(String name) {
        this.checkNotInitialized();
        this.name = name;
    }

    public Integer getOrder() {
        this.checkInitialized();
        return this.order;
    }

    protected Integer unsafeGetOrder() {
        return this.order;
    }

    public void setOrder(Integer order) {
        this.checkNotInitialized();
        this.order = order;
    }

    public TemplateResolution resolveTemplate(TemplateProcessingParameters templateProcessingParameters) {
        this.checkInitialized();
        Validate.notNull((Object)templateProcessingParameters, (String)"Template Processing Parameters cannot be null");
        ITest test = TestExecutor.getThreadTest();
        String testName = TestExecutor.getThreadTestName();
        String templateMode = test.getTemplateMode();
        if (templateMode == null) {
            throw new TestEngineExecutionException("Template mode is null for test \"" + testName + "\", which is forbidden");
        }
        ITestResource input = test.getInput();
        if (input == null) {
            throw new TestEngineExecutionException("Input is null for test \"" + testName + "\", which is forbidden");
        }
        HashMap<String, ITestResource> allInputs = new HashMap<String, ITestResource>();
        Map<String, ITestResource> additionalInputs = test.getAdditionalInputs();
        if (additionalInputs != null) {
            allInputs.putAll(additionalInputs);
        }
        allInputs.put(testName, test.getInput());
        TestResourceResolver resourceResolver = new TestResourceResolver(allInputs, TEST_TEMPLATE_CONVERSION_CHARSET);
        AlwaysValidTemplateResolutionValidity validity = test.isInputCacheable() ? AlwaysValidTemplateResolutionValidity.INSTANCE : NonCacheableTemplateResolutionValidity.INSTANCE;
        return new TemplateResolution(templateProcessingParameters.getTemplateName(), templateProcessingParameters.getTemplateName(), (IResourceResolver)resourceResolver, TEST_TEMPLATE_CONVERSION_CHARSET, templateMode, (ITemplateResolutionValidity)validity);
    }
}

