/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.testing.templateengine.context.web;

import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.validation.BindingResult;
import org.springframework.validation.DataBinder;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.StaticWebApplicationContext;
import org.springframework.web.servlet.support.RequestContext;
import org.thymeleaf.testing.templateengine.context.ITestContext;
import org.thymeleaf.testing.templateengine.context.web.WebProcessingContextBuilder;
import org.thymeleaf.testing.templateengine.messages.ITestMessages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringWebProcessingContextBuilder
extends WebProcessingContextBuilder {
    public static final String BINDING_MODEL_NAME_VARIABLE_NAME = "modelName";

    @Override
    protected void doAdditionalVariableProcessing(ITestContext testContext, ITestMessages testMessages, HttpServletRequest request, HttpServletResponse response, ServletContext servletContext, Locale locale, Map<String, Object> variables) {
        Object modelNameObj = variables.get(BINDING_MODEL_NAME_VARIABLE_NAME);
        if (modelNameObj != null) {
            String modelName = modelNameObj.toString();
            Object modelObject = variables.get(modelName);
            WebDataBinder dataBinder = new WebDataBinder(modelObject, modelName);
            this.initBinders(modelName, modelObject, testContext, testMessages, (DataBinder)dataBinder, locale);
            String bindingResultName = BindingResult.MODEL_KEY_PREFIX + modelName;
            variables.put(bindingResultName, dataBinder.getBindingResult());
        }
        StaticWebApplicationContext applicationContext = new StaticWebApplicationContext();
        applicationContext.setServletContext(servletContext);
        this.initApplicationContext(testContext, testMessages, applicationContext, locale);
        servletContext.setAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE, (Object)applicationContext);
        RequestContext requestContext = new RequestContext(request, response, servletContext, variables);
        variables.put("springRequestContext", requestContext);
    }

    protected void initBinders(String bindingModelName, Object bindingModelObject, ITestContext testContext, ITestMessages testMessages, DataBinder dataBinder, Locale locale) {
    }

    protected void initApplicationContext(ITestContext testContext, ITestMessages testMessages, StaticWebApplicationContext applicationContext, Locale locale) {
    }
}

