/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.spring4.processor;

import org.springframework.web.servlet.support.BindStatus;
import org.thymeleaf.context.ITemplateContext;
import org.thymeleaf.engine.AttributeDefinition;
import org.thymeleaf.engine.AttributeName;
import org.thymeleaf.model.IElementAttributes;
import org.thymeleaf.model.IModel;
import org.thymeleaf.model.IModelFactory;
import org.thymeleaf.model.IProcessableElementTag;
import org.thymeleaf.model.IStandaloneElementTag;
import org.thymeleaf.model.ITemplateEvent;
import org.thymeleaf.processor.element.IElementTagStructureHandler;
import org.thymeleaf.spring4.processor.AbstractSpringFieldTagProcessor;
import org.thymeleaf.spring4.requestdata.RequestDataValueProcessorUtils;
import org.thymeleaf.standard.util.StandardProcessorUtils;

public final class SpringSelectFieldTagProcessor
extends AbstractSpringFieldTagProcessor {
    static final String OPTION_IN_SELECT_ATTR_NAME = "%%OPTION_IN_SELECT_ATTR_NAME%%";
    static final String OPTION_IN_SELECT_ATTR_VALUE = "%%OPTION_IN_SELECT_ATTR_VALUE%%";

    public SpringSelectFieldTagProcessor(String dialectPrefix) {
        super(dialectPrefix, "select", null, null, true);
    }

    @Override
    protected void doProcess(ITemplateContext context, IProcessableElementTag tag, AttributeName attributeName, String attributeValue, BindStatus bindStatus, IElementTagStructureHandler structureHandler) {
        String name = bindStatus.getExpression();
        name = name == null ? "" : name;
        String id = this.computeId(context, tag, name, false);
        IElementAttributes attributes = tag.getAttributes();
        boolean multiple = attributes.hasAttribute(this.multipleAttributeDefinition.getAttributeName());
        StandardProcessorUtils.setAttribute((IElementAttributes)attributes, (AttributeDefinition)this.idAttributeDefinition, (String)"id", (String)id);
        StandardProcessorUtils.setAttribute((IElementAttributes)attributes, (AttributeDefinition)this.nameAttributeDefinition, (String)"name", (String)name);
        structureHandler.setLocalVariable(OPTION_IN_SELECT_ATTR_NAME, (Object)attributeName);
        structureHandler.setLocalVariable(OPTION_IN_SELECT_ATTR_VALUE, (Object)attributeValue);
        if (multiple && !this.isDisabled(tag)) {
            IModelFactory modelFactory = context.getConfiguration().getModelFactory(context.getTemplateMode());
            IModel hiddenMethodElementModel = modelFactory.createModel();
            String hiddenName = "_" + name;
            String type = "hidden";
            String value = RequestDataValueProcessorUtils.processFormFieldValue(context, hiddenName, "1", "hidden");
            IStandaloneElementTag hiddenMethodElementTag = modelFactory.createStandaloneElementTag("input", true);
            IElementAttributes hiddenMethodElementTagAttributes = hiddenMethodElementTag.getAttributes();
            StandardProcessorUtils.setAttribute((IElementAttributes)hiddenMethodElementTagAttributes, (AttributeDefinition)this.typeAttributeDefinition, (String)"type", (String)"hidden");
            StandardProcessorUtils.setAttribute((IElementAttributes)hiddenMethodElementTagAttributes, (AttributeDefinition)this.nameAttributeDefinition, (String)"name", (String)hiddenName);
            StandardProcessorUtils.setAttribute((IElementAttributes)hiddenMethodElementTagAttributes, (AttributeDefinition)this.valueAttributeDefinition, (String)"value", (String)value);
            hiddenMethodElementModel.add((ITemplateEvent)hiddenMethodElementTag);
            structureHandler.insertBefore(hiddenMethodElementModel);
        }
    }

    private final boolean isDisabled(IProcessableElementTag tag) {
        return tag.getAttributes().hasAttribute(this.disabledAttributeDefinition.getAttributeName());
    }
}

