/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.spring4.processor;

import java.util.Arrays;
import org.springframework.web.servlet.support.BindStatus;
import org.thymeleaf.IEngineConfiguration;
import org.thymeleaf.context.IExpressionContext;
import org.thymeleaf.context.ITemplateContext;
import org.thymeleaf.dialect.IProcessorDialect;
import org.thymeleaf.engine.AttributeName;
import org.thymeleaf.engine.AttributeNames;
import org.thymeleaf.engine.HTMLAttributeName;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.model.IProcessableElementTag;
import org.thymeleaf.processor.element.AbstractAttributeTagProcessor;
import org.thymeleaf.processor.element.IElementTagStructureHandler;
import org.thymeleaf.spring4.util.FieldUtils;
import org.thymeleaf.standard.expression.IStandardExpression;
import org.thymeleaf.standard.expression.IStandardExpressionParser;
import org.thymeleaf.standard.expression.StandardExpressions;
import org.thymeleaf.standard.expression.VariableExpression;
import org.thymeleaf.templatemode.TemplateMode;
import org.thymeleaf.util.StringUtils;
import org.unbescape.html.HtmlEscape;

public final class SpringErrorClassTagProcessor
extends AbstractAttributeTagProcessor {
    public static final int ATTR_PRECEDENCE = 1500;
    public static final String ATTR_NAME = "errorclass";
    public static final String TARGET_ATTR_NAME = "class";

    public SpringErrorClassTagProcessor(IProcessorDialect dialect, String dialectPrefix) {
        super(dialect, TemplateMode.HTML, dialectPrefix, null, false, ATTR_NAME, true, 1500, true);
    }

    protected final void doProcess(ITemplateContext context, IProcessableElementTag tag, AttributeName attributeName, String attributeValue, String attributeTemplateName, int attributeLine, int attributeCol, IElementTagStructureHandler structureHandler) {
        IEngineConfiguration configuration;
        IStandardExpressionParser expressionParser;
        IStandardExpression expression;
        Object expressionResult;
        String newAttributeValue;
        BindStatus bindStatus = SpringErrorClassTagProcessor.computeBindStatus((IExpressionContext)context, tag);
        if (bindStatus == null) {
            HTMLAttributeName fieldAttributeName = AttributeNames.forHTMLName((String)attributeName.getPrefix(), (String)"field");
            throw new TemplateProcessingException("Cannot apply \"" + attributeName + "\": this attribute requires the existence of " + "a \"name\" (or " + Arrays.asList(fieldAttributeName.getCompleteAttributeNames()) + ") attribute " + "with non-empty value in the same host tag.");
        }
        if (bindStatus.isError() && (newAttributeValue = HtmlEscape.escapeHtml4Xml((String)((expressionResult = (expression = (expressionParser = StandardExpressions.getExpressionParser((IEngineConfiguration)(configuration = context.getConfiguration()))).parseExpression((IExpressionContext)context, attributeValue)).execute((IExpressionContext)context)) == null ? null : expressionResult.toString()))) != null && newAttributeValue.length() > 0) {
            if (!tag.getAttributes().hasAttribute(TARGET_ATTR_NAME) || tag.getAttributes().getValue(TARGET_ATTR_NAME).length() == 0) {
                tag.getAttributes().setAttribute(TARGET_ATTR_NAME, newAttributeValue);
            } else {
                String currentValue = tag.getAttributes().getValue(TARGET_ATTR_NAME);
                tag.getAttributes().setAttribute(TARGET_ATTR_NAME, currentValue + ' ' + newAttributeValue);
            }
        }
    }

    private static BindStatus computeBindStatus(IExpressionContext context, IProcessableElementTag tag) {
        BindStatus bindStatus = (BindStatus)context.getVariable("springFieldBindStatus");
        if (bindStatus != null) {
            return bindStatus;
        }
        String fieldName = tag.getAttributes().getValue("name");
        if (StringUtils.isEmptyOrWhitespace((String)fieldName)) {
            return null;
        }
        VariableExpression boundExpression = (VariableExpression)context.getVariable("springBoundObjectExpression");
        if (boundExpression == null) {
            return FieldUtils.getBindStatusFromParsedExpression(context, false, fieldName);
        }
        String boundExpressionStr = boundExpression.getExpression();
        String computedFieldName = boundExpressionStr.indexOf(46) == -1 ? boundExpressionStr + '.' + fieldName : boundExpressionStr.substring(0, boundExpressionStr.indexOf(46)) + '.' + fieldName;
        return FieldUtils.getBindStatusFromParsedExpression(context, false, computedFieldName);
    }
}

