/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.spring4.dialect;

import java.util.LinkedHashSet;
import java.util.Set;
import org.thymeleaf.dialect.IProcessorDialect;
import org.thymeleaf.expression.IExpressionObjectFactory;
import org.thymeleaf.processor.IProcessor;
import org.thymeleaf.spring4.expression.SPELVariableExpressionEvaluator;
import org.thymeleaf.spring4.expression.SpringStandardConversionService;
import org.thymeleaf.spring4.expression.SpringStandardExpressionObjectFactory;
import org.thymeleaf.spring4.processor.SpringActionTagProcessor;
import org.thymeleaf.spring4.processor.SpringErrorClassTagProcessor;
import org.thymeleaf.spring4.processor.SpringErrorsTagProcessor;
import org.thymeleaf.spring4.processor.SpringHrefTagProcessor;
import org.thymeleaf.spring4.processor.SpringInputCheckboxFieldTagProcessor;
import org.thymeleaf.spring4.processor.SpringInputFileFieldTagProcessor;
import org.thymeleaf.spring4.processor.SpringInputGeneralFieldTagProcessor;
import org.thymeleaf.spring4.processor.SpringInputPasswordFieldTagProcessor;
import org.thymeleaf.spring4.processor.SpringInputRadioFieldTagProcessor;
import org.thymeleaf.spring4.processor.SpringMethodTagProcessor;
import org.thymeleaf.spring4.processor.SpringObjectTagProcessor;
import org.thymeleaf.spring4.processor.SpringOptionFieldTagProcessor;
import org.thymeleaf.spring4.processor.SpringOptionInSelectFieldTagProcessor;
import org.thymeleaf.spring4.processor.SpringSelectFieldTagProcessor;
import org.thymeleaf.spring4.processor.SpringSrcTagProcessor;
import org.thymeleaf.spring4.processor.SpringTextareaFieldTagProcessor;
import org.thymeleaf.spring4.processor.SpringTranslationDocTypeProcessor;
import org.thymeleaf.spring4.processor.SpringValueTagProcessor;
import org.thymeleaf.standard.StandardDialect;
import org.thymeleaf.standard.expression.IStandardConversionService;
import org.thymeleaf.standard.expression.IStandardVariableExpressionEvaluator;
import org.thymeleaf.standard.processor.StandardActionTagProcessor;
import org.thymeleaf.standard.processor.StandardHrefTagProcessor;
import org.thymeleaf.standard.processor.StandardMethodTagProcessor;
import org.thymeleaf.standard.processor.StandardObjectTagProcessor;
import org.thymeleaf.standard.processor.StandardSrcTagProcessor;
import org.thymeleaf.standard.processor.StandardValueTagProcessor;
import org.thymeleaf.templatemode.TemplateMode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringStandardDialect
extends StandardDialect {
    public static final String NAME = "SpringStandard";
    public static final String PREFIX = "th";
    public static final int PROCESSOR_PRECEDENCE = 1000;
    private final IExpressionObjectFactory SPRING_STANDARD_EXPRESSION_OBJECTS_FACTORY = new SpringStandardExpressionObjectFactory();
    private final IStandardConversionService SPRING_STANDARD_CONVERSION_SERVICE = new SpringStandardConversionService();

    public SpringStandardDialect() {
        super(NAME, PREFIX, 1000);
    }

    public IStandardVariableExpressionEvaluator getVariableExpressionEvaluator() {
        return SPELVariableExpressionEvaluator.INSTANCE;
    }

    public IStandardConversionService getConversionService() {
        return this.SPRING_STANDARD_CONVERSION_SERVICE;
    }

    public IExpressionObjectFactory getExpressionObjectFactory() {
        return this.SPRING_STANDARD_EXPRESSION_OBJECTS_FACTORY;
    }

    public Set<IProcessor> getProcessors(String dialectPrefix) {
        return SpringStandardDialect.createSpringStandardProcessorsSet((IProcessorDialect)this, dialectPrefix);
    }

    public static Set<IProcessor> createSpringStandardProcessorsSet(IProcessorDialect dialect, String dialectPrefix) {
        Set standardProcessors = StandardDialect.createStandardProcessorsSet((IProcessorDialect)dialect, (String)dialectPrefix);
        LinkedHashSet<IProcessor> processors = new LinkedHashSet<IProcessor>(40);
        for (IProcessor standardProcessor : standardProcessors) {
            if (!(standardProcessor instanceof StandardObjectTagProcessor || standardProcessor instanceof StandardActionTagProcessor || standardProcessor instanceof StandardHrefTagProcessor || standardProcessor instanceof StandardMethodTagProcessor || standardProcessor instanceof StandardSrcTagProcessor || standardProcessor instanceof StandardValueTagProcessor)) {
                processors.add(standardProcessor);
                continue;
            }
            if (standardProcessor.getTemplateMode() == TemplateMode.HTML) continue;
            processors.add(standardProcessor);
        }
        processors.add((IProcessor)new SpringActionTagProcessor(dialect, dialectPrefix));
        processors.add((IProcessor)new SpringHrefTagProcessor(dialect, dialectPrefix));
        processors.add((IProcessor)new SpringMethodTagProcessor(dialect, dialectPrefix));
        processors.add((IProcessor)new SpringSrcTagProcessor(dialect, dialectPrefix));
        processors.add((IProcessor)new SpringValueTagProcessor(dialect, dialectPrefix));
        processors.add((IProcessor)new SpringObjectTagProcessor(dialect, dialectPrefix));
        processors.add((IProcessor)new SpringErrorsTagProcessor(dialect, dialectPrefix));
        processors.add((IProcessor)new SpringInputGeneralFieldTagProcessor(dialect, dialectPrefix));
        processors.add((IProcessor)new SpringInputPasswordFieldTagProcessor(dialect, dialectPrefix));
        processors.add((IProcessor)new SpringInputCheckboxFieldTagProcessor(dialect, dialectPrefix));
        processors.add((IProcessor)new SpringInputRadioFieldTagProcessor(dialect, dialectPrefix));
        processors.add((IProcessor)new SpringInputFileFieldTagProcessor(dialect, dialectPrefix));
        processors.add((IProcessor)new SpringSelectFieldTagProcessor(dialect, dialectPrefix));
        processors.add((IProcessor)new SpringOptionInSelectFieldTagProcessor(dialect, dialectPrefix));
        processors.add((IProcessor)new SpringOptionFieldTagProcessor(dialect, dialectPrefix));
        processors.add((IProcessor)new SpringTextareaFieldTagProcessor(dialect, dialectPrefix));
        processors.add((IProcessor)new SpringErrorClassTagProcessor(dialect, dialectPrefix));
        processors.add((IProcessor)new SpringTranslationDocTypeProcessor(dialect));
        return processors;
    }
}

