/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.spring4.processor;

import org.springframework.web.servlet.support.BindStatus;
import org.springframework.web.servlet.tags.form.SelectedValueComparatorWrapper;
import org.thymeleaf.context.IProcessingContext;
import org.thymeleaf.context.ITemplateProcessingContext;
import org.thymeleaf.engine.AttributeName;
import org.thymeleaf.engine.IElementStructureHandler;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.model.IProcessableElementTag;
import org.thymeleaf.spring4.processor.AbstractSpringFieldTagProcessor;
import org.thymeleaf.spring4.requestdata.RequestDataValueProcessorUtils;
import org.unbescape.html.HtmlEscape;

public final class SpringOptionFieldTagProcessor
extends AbstractSpringFieldTagProcessor {
    public SpringOptionFieldTagProcessor(String dialectPrefix) {
        super(dialectPrefix, "option", null, null);
    }

    protected void doProcess(ITemplateProcessingContext processingContext, IProcessableElementTag tag, AttributeName attributeName, String attributeValue, BindStatus bindStatus, IElementStructureHandler structureHandler) {
        String name = bindStatus.getExpression();
        name = name == null ? "" : name;
        String value = tag.getAttributes().getValue("value");
        if (value == null) {
            throw new TemplateProcessingException("Attribute \"value\" is required in \"option\" tags");
        }
        boolean selected = SelectedValueComparatorWrapper.isSelected(bindStatus, HtmlEscape.unescapeHtml((String)value));
        tag.getAttributes().setAttribute("value", RequestDataValueProcessorUtils.processFormFieldValue((IProcessingContext)processingContext, name, value, "option"));
        if (selected) {
            tag.getAttributes().setAttribute("selected", "selected");
        } else {
            tag.getAttributes().removeAttribute("selected");
        }
        tag.getAttributes().removeAttribute(attributeName);
    }
}

