/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.spring4.resourceresolver;

import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.io.Resource;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.TemplateProcessingParameters;
import org.thymeleaf.resourceresolver.IResourceResolver;
import org.thymeleaf.util.Validate;

public final class SpringResourceResourceResolver
implements IResourceResolver,
ApplicationContextAware {
    private static final Logger logger = LoggerFactory.getLogger(SpringResourceResourceResolver.class);
    public static final String NAME = "SPRING-RESOURCE";
    private ApplicationContext applicationContext = null;

    public String getName() {
        return NAME;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public InputStream getResourceAsStream(TemplateProcessingParameters templateProcessingParameters, String resourceName) {
        Validate.notNull((Object)resourceName, (String)"Resource name cannot be null");
        Validate.notNull((Object)this.applicationContext, (String)"ApplicationContext has not been initialized in resource resolver. TemplateResolver or ResourceResolver might not have been correctly configured by the Spring Application Context.");
        try {
            Resource resource = this.applicationContext.getResource(resourceName);
            if (resource == null) {
                return null;
            }
            return resource.getInputStream();
        }
        catch (IOException e) {
            if (logger.isDebugEnabled()) {
                if (logger.isTraceEnabled()) {
                    logger.trace(String.format("[THYMELEAF][%s][%s] Resource \"%s\" could not be resolved. This can be normal as maybe this resource is not intended to be resolved by this resolver. Exception is provided for tracing purposes: ", TemplateEngine.threadIndex(), templateProcessingParameters.getTemplateName(), resourceName), (Throwable)e);
                } else {
                    logger.debug(String.format("[THYMELEAF][%s][%s] Resource \"%s\" could not be resolved. This can be normal as maybe this resource is not intended to be resolved by this resolver. Exception message is provided: %s: %s", TemplateEngine.threadIndex(), templateProcessingParameters.getTemplateName(), resourceName, e.getClass().getName(), e.getMessage()));
                }
            }
            return null;
        }
    }
}

