/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.extras.springsecurity3.dialect.processor;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.core.Authentication;
import org.thymeleaf.context.IExpressionContext;
import org.thymeleaf.context.ITemplateContext;
import org.thymeleaf.context.IWebContext;
import org.thymeleaf.engine.AttributeName;
import org.thymeleaf.exceptions.ConfigurationException;
import org.thymeleaf.extras.springsecurity3.auth.AuthUtils;
import org.thymeleaf.model.IProcessableElementTag;
import org.thymeleaf.standard.processor.AbstractStandardConditionalVisibilityTagProcessor;
import org.thymeleaf.templatemode.TemplateMode;

public final class AuthorizeAttrProcessor
extends AbstractStandardConditionalVisibilityTagProcessor {
    public static final int ATTR_PRECEDENCE = 300;
    public static final String ATTR_NAME = "authorize";
    public static final String ATTR_NAME_EXPR = "authorize-expr";

    public AuthorizeAttrProcessor(String dialectPrefix, String attrName) {
        super(TemplateMode.HTML, dialectPrefix, attrName, 300);
    }

    protected boolean isVisible(ITemplateContext context, IProcessableElementTag tag, AttributeName attributeName, String attributeValue) {
        String attrValue;
        String string = attrValue = attributeValue == null ? null : attributeValue.trim();
        if (attrValue == null || attrValue.length() == 0) {
            return false;
        }
        if (!(context instanceof IWebContext)) {
            throw new ConfigurationException("Thymeleaf execution context is not a web context (implementation of " + IWebContext.class.getName() + "). Spring Security integration can only be used in " + "web environments.");
        }
        IWebContext webContext = (IWebContext)context;
        HttpServletRequest request = webContext.getRequest();
        HttpServletResponse response = webContext.getResponse();
        ServletContext servletContext = webContext.getServletContext();
        Authentication authentication = AuthUtils.getAuthenticationObject();
        if (authentication == null) {
            return false;
        }
        return AuthUtils.authorizeUsingAccessExpression((IExpressionContext)context, attrValue, authentication, request, response, servletContext);
    }
}

