/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.extras.java8time.util;

import java.lang.reflect.Array;
import java.time.ZoneId;
import java.util.Locale;
import java.util.function.Function;
import java.util.stream.Stream;
import org.thymeleaf.extras.java8time.util.TemporalFormattingUtils;
import org.thymeleaf.util.Validate;

public final class TemporalArrayUtils {
    private final TemporalFormattingUtils temporalFormattingUtils;

    public TemporalArrayUtils(Locale locale, ZoneId defaultZoneId) {
        Validate.notNull((Object)locale, (String)"Locale cannot be null");
        Validate.notNull((Object)defaultZoneId, (String)"ZoneId cannot be null");
        this.temporalFormattingUtils = new TemporalFormattingUtils(locale, defaultZoneId);
    }

    public String[] arrayFormat(Object[] target) {
        return this.arrayFormat(target, this.temporalFormattingUtils::format, String.class);
    }

    public String[] arrayFormat(Object[] target, String pattern) {
        return this.arrayFormat(target, time -> this.temporalFormattingUtils.format(time, pattern), String.class);
    }

    public Integer[] arrayDay(Object[] target) {
        return this.arrayFormat(target, this.temporalFormattingUtils::day, Integer.class);
    }

    public Integer[] arrayMonth(Object[] target) {
        return this.arrayFormat(target, this.temporalFormattingUtils::month, Integer.class);
    }

    public String[] arrayMonthName(Object[] target) {
        return this.arrayFormat(target, this.temporalFormattingUtils::monthName, String.class);
    }

    public String[] arrayMonthNameShort(Object[] target) {
        return this.arrayFormat(target, this.temporalFormattingUtils::monthNameShort, String.class);
    }

    public Integer[] arrayYear(Object[] target) {
        return this.arrayFormat(target, this.temporalFormattingUtils::year, Integer.class);
    }

    public Integer[] arrayDayOfWeek(Object[] target) {
        return this.arrayFormat(target, this.temporalFormattingUtils::dayOfWeek, Integer.class);
    }

    public String[] arrayDayOfWeekName(Object[] target) {
        return this.arrayFormat(target, this.temporalFormattingUtils::dayOfWeekName, String.class);
    }

    public String[] arrayDayOfWeekNameShort(Object[] target) {
        return this.arrayFormat(target, this.temporalFormattingUtils::dayOfWeekNameShort, String.class);
    }

    public Integer[] arrayHour(Object[] target) {
        return this.arrayFormat(target, this.temporalFormattingUtils::hour, Integer.class);
    }

    public Integer[] arrayMinute(Object[] target) {
        return this.arrayFormat(target, this.temporalFormattingUtils::minute, Integer.class);
    }

    public Integer[] arraySecond(Object[] target) {
        return this.arrayFormat(target, this.temporalFormattingUtils::second, Integer.class);
    }

    public Integer[] arrayNanosecond(Object[] target) {
        return this.arrayFormat(target, this.temporalFormattingUtils::nanosecond, Integer.class);
    }

    public String[] arrayFormatISO(Object[] target) {
        return this.arrayFormat(target, this.temporalFormattingUtils::formatISO, String.class);
    }

    private <R> R[] arrayFormat(Object[] target, Function<Object, R> mapFunction, Class<R> returnType) {
        Validate.notNull((Object)target, (String)"Target cannot be null");
        return Stream.of(target).map(time -> mapFunction.apply(time)).toArray(length -> (Object[])Array.newInstance(returnType, length));
    }
}

