/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.selenium;

import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.model.AccessMode;
import com.github.dockerjava.api.model.Bind;
import com.github.dockerjava.api.model.Volume;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.SystemUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.ContainerLaunchException;
import org.testcontainers.containers.DefaultRecordingFileFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.RecordingFileFactory;
import org.testcontainers.containers.VncRecordingContainer;
import org.testcontainers.containers.wait.strategy.HostPortWaitStrategy;
import org.testcontainers.containers.wait.strategy.LogMessageWaitStrategy;
import org.testcontainers.containers.wait.strategy.WaitAllStrategy;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.lifecycle.TestDescription;
import org.testcontainers.lifecycle.TestLifecycleAware;
import org.testcontainers.shaded.com.google.common.collect.ImmutableSet;
import org.testcontainers.utility.DockerImageName;

public class BrowserWebDriverContainer
extends GenericContainer<BrowserWebDriverContainer>
implements TestLifecycleAware {
    private static final DockerImageName CHROME_IMAGE = DockerImageName.parse((String)"selenium/standalone-chrome");
    private static final DockerImageName FIREFOX_IMAGE = DockerImageName.parse((String)"selenium/standalone-firefox");
    private static final DockerImageName EDGE_IMAGE = DockerImageName.parse((String)"selenium/standalone-edge");
    private static final DockerImageName CHROME_DEBUG_IMAGE = DockerImageName.parse((String)"selenium/standalone-chrome-debug");
    private static final DockerImageName FIREFOX_DEBUG_IMAGE = DockerImageName.parse((String)"selenium/standalone-firefox-debug");
    private static final DockerImageName[] COMPATIBLE_IMAGES = new DockerImageName[]{CHROME_IMAGE, FIREFOX_IMAGE, EDGE_IMAGE, CHROME_DEBUG_IMAGE, FIREFOX_DEBUG_IMAGE};
    private static final String DEFAULT_PASSWORD = "secret";
    private static final int SELENIUM_PORT = 4444;
    private static final int VNC_PORT = 5900;
    private static final String NO_PROXY_KEY = "no_proxy";
    private static final String TC_TEMP_DIR_PREFIX = "tc";
    private VncRecordingMode recordingMode = VncRecordingMode.RECORD_FAILING;
    private VncRecordingContainer.VncRecordingFormat recordingFormat;
    private RecordingFileFactory recordingFileFactory;
    private File vncRecordingDirectory;
    private VncRecordingContainer vncRecordingContainer = null;
    private static final Logger LOGGER = LoggerFactory.getLogger(BrowserWebDriverContainer.class);

    public BrowserWebDriverContainer(String dockerImageName) {
        this(DockerImageName.parse((String)dockerImageName));
    }

    public BrowserWebDriverContainer(DockerImageName dockerImageName) {
        super(dockerImageName);
        dockerImageName.assertCompatibleWith(COMPATIBLE_IMAGES);
        this.waitingFor(this.getDefaultWaitStrategy());
        this.withRecordingFileFactory(new DefaultRecordingFileFactory());
        this.recordingMode = VncRecordingMode.SKIP;
    }

    @NotNull
    protected Set<Integer> getLivenessCheckPorts() {
        Integer seleniumPort = this.getMappedPort(4444);
        if (this.recordingMode == VncRecordingMode.SKIP) {
            return ImmutableSet.of((Object)seleniumPort);
        }
        return ImmutableSet.of((Object)seleniumPort, (Object)this.getMappedPort(5900));
    }

    protected void configure() {
        String timeZone;
        if (this.recordingMode != VncRecordingMode.SKIP) {
            if (this.vncRecordingDirectory == null) {
                try {
                    this.vncRecordingDirectory = Files.createTempDirectory(TC_TEMP_DIR_PREFIX, new FileAttribute[0]).toFile();
                }
                catch (IOException e) {
                    this.logger().error("Exception while trying to create temp directory", (Throwable)e);
                    throw new ContainerLaunchException("Exception while trying to create temp directory", (Throwable)e);
                }
            }
            if (this.getNetwork() == null) {
                this.withNetwork(Network.SHARED);
            }
            this.vncRecordingContainer = new VncRecordingContainer((GenericContainer)this).withVncPassword(DEFAULT_PASSWORD).withVncPort(5900).withVideoFormat(this.recordingFormat);
        }
        if ((timeZone = System.getProperty("user.timezone")) == null || timeZone.isEmpty()) {
            timeZone = "Etc/UTC";
        }
        this.addExposedPorts(new int[]{4444, 5900});
        this.addEnv("TZ", timeZone);
        if (!this.getEnvMap().containsKey(NO_PROXY_KEY)) {
            this.addEnv(NO_PROXY_KEY, "localhost");
        }
        this.setCommand("/opt/bin/entry_point.sh");
        if (this.getShmSize() == null) {
            if (SystemUtils.IS_OS_WINDOWS) {
                this.withSharedMemorySize(0x20000000L);
            } else {
                this.getBinds().add(new Bind("/dev/shm", new Volume("/dev/shm"), AccessMode.rw));
            }
        }
        this.setStartupAttempts(3);
    }

    public URL getSeleniumAddress() {
        try {
            return new URL("http", this.getHost(), this.getMappedPort(4444), "/wd/hub");
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getVncAddress() {
        return "vnc://vnc:secret@" + this.getHost() + ":" + this.getMappedPort(5900);
    }

    protected void containerIsStarted(InspectContainerResponse containerInfo) {
        if (this.vncRecordingContainer != null) {
            LOGGER.debug("Starting VNC recording");
            this.vncRecordingContainer.start();
        }
    }

    public void afterTest(TestDescription description, Optional<Throwable> throwable) {
        this.retainRecordingIfNeeded(description.getFilesystemFriendlyName(), !throwable.isPresent());
    }

    public void stop() {
        if (this.vncRecordingContainer != null) {
            try {
                this.vncRecordingContainer.stop();
            }
            catch (Exception e) {
                LOGGER.debug("Failed to stop vncRecordingContainer", (Throwable)e);
            }
            this.vncRecordingContainer = null;
        }
        super.stop();
    }

    private void retainRecordingIfNeeded(String prefix, boolean succeeded) {
        boolean shouldRecord;
        switch (this.recordingMode) {
            case RECORD_ALL: {
                shouldRecord = true;
                break;
            }
            case RECORD_FAILING: {
                shouldRecord = !succeeded;
                break;
            }
            default: {
                shouldRecord = false;
            }
        }
        if (shouldRecord) {
            File recordingFile = this.recordingFileFactory.recordingFileForTest(this.vncRecordingDirectory, prefix, succeeded, this.vncRecordingContainer.getVideoFormat());
            LOGGER.info("Screen recordings for test {} will be stored at: {}", (Object)prefix, (Object)recordingFile);
            this.vncRecordingContainer.saveRecordingToFile(recordingFile);
        }
    }

    public BrowserWebDriverContainer withRecordingMode(VncRecordingMode recordingMode, File vncRecordingDirectory) {
        return this.withRecordingMode(recordingMode, vncRecordingDirectory, null);
    }

    public BrowserWebDriverContainer withRecordingMode(VncRecordingMode recordingMode, File vncRecordingDirectory, VncRecordingContainer.VncRecordingFormat recordingFormat) {
        this.recordingMode = recordingMode;
        this.vncRecordingDirectory = vncRecordingDirectory;
        this.recordingFormat = recordingFormat;
        return (BrowserWebDriverContainer)this.self();
    }

    public BrowserWebDriverContainer withRecordingFileFactory(RecordingFileFactory recordingFileFactory) {
        this.recordingFileFactory = recordingFileFactory;
        return (BrowserWebDriverContainer)this.self();
    }

    private WaitStrategy getDefaultWaitStrategy() {
        WaitStrategy logWaitStrategy = new LogMessageWaitStrategy().withRegEx(".*(RemoteWebDriver instances should connect to|Selenium Server is up and running|Started Selenium Standalone).*\n").withStartupTimeout(Duration.ofMinutes(1L));
        return new WaitAllStrategy().withStrategy(logWaitStrategy).withStrategy((WaitStrategy)new HostPortWaitStrategy()).withStartupTimeout(Duration.ofMinutes(1L));
    }

    public static enum VncRecordingMode {
        SKIP,
        RECORD_ALL,
        RECORD_FAILING;

    }
}

