/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.shaded.freemarker.ext.beans;

import java.util.AbstractList;
import org.testcontainers.shaded.freemarker.ext.beans.BeansWrapper;
import org.testcontainers.shaded.freemarker.template.TemplateModel;
import org.testcontainers.shaded.freemarker.template.TemplateModelAdapter;
import org.testcontainers.shaded.freemarker.template.TemplateModelException;
import org.testcontainers.shaded.freemarker.template.TemplateSequenceModel;
import org.testcontainers.shaded.freemarker.template.utility.UndeclaredThrowableException;

class SequenceAdapter
extends AbstractList
implements TemplateModelAdapter {
    private final BeansWrapper wrapper;
    private final TemplateSequenceModel model;

    SequenceAdapter(TemplateSequenceModel model, BeansWrapper wrapper) {
        this.model = model;
        this.wrapper = wrapper;
    }

    @Override
    public TemplateModel getTemplateModel() {
        return this.model;
    }

    @Override
    public int size() {
        try {
            return this.model.size();
        }
        catch (TemplateModelException e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    @Override
    public Object get(int index) {
        try {
            return this.wrapper.unwrap(this.model.get(index));
        }
        catch (TemplateModelException e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    public TemplateSequenceModel getTemplateSequenceModel() {
        return this.model;
    }
}

