/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.qdrant;

import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.images.builder.Transferable;
import org.testcontainers.utility.DockerImageName;

public class QdrantContainer
extends GenericContainer<QdrantContainer> {
    private static final DockerImageName DEFAULT_IMAGE_NAME = DockerImageName.parse((String)"qdrant/qdrant");
    private static final int QDRANT_REST_PORT = 6333;
    private static final int QDRANT_GRPC_PORT = 6334;
    private static final String CONFIG_FILE_PATH = "/qdrant/config/config.yaml";
    private static final String API_KEY_ENV = "QDRANT__SERVICE__API_KEY";

    public QdrantContainer(String image) {
        this(DockerImageName.parse((String)image));
    }

    public QdrantContainer(DockerImageName dockerImageName) {
        super(dockerImageName);
        dockerImageName.assertCompatibleWith(new DockerImageName[]{DEFAULT_IMAGE_NAME});
        this.withExposedPorts(new Integer[]{6333, 6334});
        this.waitingFor((WaitStrategy)Wait.forHttp((String)"/readyz").forPort(6333));
    }

    public QdrantContainer withApiKey(String apiKey) {
        return (QdrantContainer)this.withEnv(API_KEY_ENV, apiKey);
    }

    public QdrantContainer withConfigFile(Transferable configFile) {
        return (QdrantContainer)this.withCopyToContainer(configFile, CONFIG_FILE_PATH);
    }

    public int getGrpcPort() {
        return this.getMappedPort(6334);
    }

    public String getGrpcHostAddress() {
        return this.getHost() + ":" + this.getGrpcPort();
    }
}

