/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers.localstack;

import com.github.dockerjava.api.command.InspectContainerResponse;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.rnorth.ducttape.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.DockerClientFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.images.builder.Transferable;
import org.testcontainers.utility.ComparableVersion;
import org.testcontainers.utility.DockerImageName;

public class LocalStackContainer
extends GenericContainer<LocalStackContainer> {
    private static final Logger log = LoggerFactory.getLogger(LocalStackContainer.class);
    static final int PORT = 4566;
    @Deprecated
    private static final String HOSTNAME_EXTERNAL_ENV_VAR = "HOSTNAME_EXTERNAL";
    private static final String LOCALSTACK_HOST_ENV_VAR = "LOCALSTACK_HOST";
    private final List<EnabledService> services = new ArrayList<EnabledService>();
    private static final DockerImageName DEFAULT_IMAGE_NAME = DockerImageName.parse((String)"localstack/localstack");
    private static final DockerImageName LOCALSTACK_PRO_IMAGE_NAME = DockerImageName.parse((String)"localstack/localstack-pro");
    private static final String DEFAULT_TAG = "0.11.2";
    private static final String DEFAULT_REGION = "us-east-1";
    private static final String DEFAULT_AWS_ACCESS_KEY_ID = "test";
    private static final String DEFAULT_AWS_SECRET_ACCESS_KEY = "test";
    private static final String STARTER_SCRIPT = "/testcontainers_start.sh";
    @Deprecated
    public static final String VERSION = "0.11.2";
    private final boolean legacyMode;
    private final boolean servicesEnvVarRequired;
    private final boolean isVersion2;

    @Deprecated
    public LocalStackContainer() {
        this(DEFAULT_IMAGE_NAME.withTag("0.11.2"));
    }

    @Deprecated
    public LocalStackContainer(String version) {
        this(DEFAULT_IMAGE_NAME.withTag(version));
    }

    public LocalStackContainer(DockerImageName dockerImageName) {
        this(dockerImageName, LocalStackContainer.shouldRunInLegacyMode(dockerImageName.getVersionPart()));
    }

    @Deprecated
    public LocalStackContainer(DockerImageName dockerImageName, boolean useLegacyMode) {
        super(dockerImageName);
        dockerImageName.assertCompatibleWith(new DockerImageName[]{DEFAULT_IMAGE_NAME, LOCALSTACK_PRO_IMAGE_NAME});
        this.legacyMode = useLegacyMode;
        String version = dockerImageName.getVersionPart();
        this.servicesEnvVarRequired = LocalStackContainer.isServicesEnvVarRequired(version);
        this.isVersion2 = LocalStackContainer.isVersion2(version);
        this.withFileSystemBind(DockerClientFactory.instance().getRemoteDockerUnixSocketPath(), "/var/run/docker.sock");
        this.waitingFor((WaitStrategy)Wait.forLogMessage((String)".*Ready\\.\n", (int)1));
        this.withCreateContainerCmdModifier(cmd -> cmd.withEntrypoint(new String[]{"sh"}));
        this.setCommand(new String[]{"-c", "while [ ! -f /testcontainers_start.sh ]; do sleep 0.1; done; /testcontainers_start.sh"});
    }

    private static boolean isVersion2(String version) {
        if (version.equals("latest")) {
            return true;
        }
        ComparableVersion comparableVersion = new ComparableVersion(version);
        return comparableVersion.isGreaterThanOrEqualTo("2.0.0");
    }

    private static boolean isServicesEnvVarRequired(String version) {
        if (version.equals("latest")) {
            return false;
        }
        ComparableVersion comparableVersion = new ComparableVersion(version);
        if (comparableVersion.isSemanticVersion()) {
            return comparableVersion.isLessThan("0.13");
        }
        log.warn("Version {} is not a semantic version, services list is required.", (Object)version);
        return true;
    }

    static boolean shouldRunInLegacyMode(String version) {
        if (version.equals("latest") || version.startsWith("latest-") || version.endsWith("-latest")) {
            return false;
        }
        ComparableVersion comparableVersion = new ComparableVersion(version);
        if (comparableVersion.isSemanticVersion()) {
            boolean versionRequiresLegacyMode = comparableVersion.isLessThan("0.11");
            return versionRequiresLegacyMode;
        }
        log.warn("Version {} is not a semantic version, LocalStack will run in legacy mode.", (Object)version);
        log.warn("Consider using \"LocalStackContainer(DockerImageName dockerImageName, boolean legacyMode)\" constructor if you want to disable legacy mode.");
        return true;
    }

    protected void configure() {
        super.configure();
        if (this.servicesEnvVarRequired) {
            Preconditions.check((String)"services list must not be empty", (!this.services.isEmpty() ? 1 : 0) != 0);
        }
        if (!this.services.isEmpty()) {
            this.withEnv("SERVICES", this.services.stream().map(EnabledService::getName).collect(Collectors.joining(",")));
            if (this.servicesEnvVarRequired) {
                this.withEnv("EAGER_SERVICE_LOADING", "1");
            }
        }
        if (this.isVersion2) {
            this.resolveHostname(LOCALSTACK_HOST_ENV_VAR);
        } else {
            this.resolveHostname(HOSTNAME_EXTERNAL_ENV_VAR);
        }
        this.exposePorts();
    }

    protected void containerIsStarting(InspectContainerResponse containerInfo) {
        String command = "#!/bin/bash\n";
        command = command + "export LAMBDA_DOCKER_FLAGS=" + this.configureLambdaContainerLabels() + "\n";
        command = command + "/usr/local/bin/docker-entrypoint.sh\n";
        this.copyFileToContainer(Transferable.of((String)command, (int)511), STARTER_SCRIPT);
    }

    private String configureLambdaContainerLabels() {
        String lambdaDockerFlags = this.internalMarkerLabels();
        String existingLambdaDockerFlags = (String)this.getEnvMap().get("LAMBDA_DOCKER_FLAGS");
        if (existingLambdaDockerFlags != null) {
            lambdaDockerFlags = existingLambdaDockerFlags + " " + lambdaDockerFlags;
        }
        return "\"" + lambdaDockerFlags + "\"";
    }

    private String internalMarkerLabels() {
        return this.getContainerInfo().getConfig().getLabels().entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith(DockerClientFactory.TESTCONTAINERS_LABEL)).filter(entry -> !((String)entry.getKey()).equals("org.testcontainers.hash") && !((String)entry.getKey()).equals("org.testcontainers.copied_files.hash")).map(entry -> String.format("-l %s=%s", entry.getKey(), entry.getValue())).collect(Collectors.joining(" "));
    }

    private void resolveHostname(String envVar) {
        String hostnameExternalReason;
        if (this.getEnvMap().containsKey(envVar)) {
            hostnameExternalReason = "explicitly as environment variable";
        } else if (this.getNetwork() != null && this.getNetworkAliases() != null && this.getNetworkAliases().size() >= 1) {
            this.withEnv(envVar, (String)this.getNetworkAliases().get(this.getNetworkAliases().size() - 1));
            hostnameExternalReason = "to match last network alias on container with non-default network";
        } else {
            this.withEnv(envVar, this.getHost());
            hostnameExternalReason = "to match host-routable address for container";
        }
        this.logger().info("{} environment variable set to {} ({})", new Object[]{envVar, this.getEnvMap().get(envVar), hostnameExternalReason});
    }

    private void exposePorts() {
        if (this.legacyMode) {
            this.services.stream().map(this::getServicePort).distinct().forEach(arg_0 -> ((LocalStackContainer)this).addExposedPort(arg_0));
        } else {
            this.addExposedPort(4566);
        }
    }

    public LocalStackContainer withServices(Service ... services) {
        this.services.addAll(Arrays.asList(services));
        return (LocalStackContainer)this.self();
    }

    public LocalStackContainer withServices(EnabledService ... services) {
        this.services.addAll(Arrays.asList(services));
        return (LocalStackContainer)this.self();
    }

    public URI getEndpointOverride(Service service) {
        return this.getEndpointOverride((EnabledService)service);
    }

    public URI getEndpointOverride(EnabledService service) {
        try {
            String address;
            String ipAddress = address = this.getHost();
            ipAddress = InetAddress.getByName(address).getHostAddress();
            return new URI("http://" + ipAddress + ":" + this.getMappedPort(this.getServicePort(service)));
        }
        catch (URISyntaxException | UnknownHostException e) {
            throw new IllegalStateException("Cannot obtain endpoint URL", e);
        }
    }

    public URI getEndpoint() {
        try {
            String address = this.getHost();
            String ipAddress = InetAddress.getByName(address).getHostAddress();
            return new URI("http://" + ipAddress + ":" + this.getMappedPort(4566));
        }
        catch (URISyntaxException | UnknownHostException e) {
            throw new IllegalStateException("Cannot obtain endpoint URL", e);
        }
    }

    private int getServicePort(EnabledService service) {
        return this.legacyMode ? service.getPort() : 4566;
    }

    public String getAccessKey() {
        return this.getEnvMap().getOrDefault("AWS_ACCESS_KEY_ID", "test");
    }

    public String getSecretKey() {
        return this.getEnvMap().getOrDefault("AWS_SECRET_ACCESS_KEY", "test");
    }

    public String getRegion() {
        return this.getEnvMap().getOrDefault("DEFAULT_REGION", DEFAULT_REGION);
    }

    public static enum Service implements EnabledService
    {
        API_GATEWAY("apigateway", 4567),
        EC2("ec2", 4597),
        KINESIS("kinesis", 4568),
        DYNAMODB("dynamodb", 4569),
        DYNAMODB_STREAMS("dynamodbstreams", 4570),
        S3("s3", 4572),
        FIREHOSE("firehose", 4573),
        LAMBDA("lambda", 4574),
        SNS("sns", 4575),
        SQS("sqs", 4576),
        REDSHIFT("redshift", 4577),
        SES("ses", 4579),
        ROUTE53("route53", 4580),
        CLOUDFORMATION("cloudformation", 4581),
        CLOUDWATCH("cloudwatch", 4582),
        SSM("ssm", 4583),
        SECRETSMANAGER("secretsmanager", 4584),
        STEPFUNCTIONS("stepfunctions", 4585),
        CLOUDWATCHLOGS("logs", 4586),
        STS("sts", 4592),
        IAM("iam", 4593),
        KMS("kms", 4599);

        final String localStackName;
        final int port;

        @Override
        public String getName() {
            return this.localStackName;
        }

        @Override
        @Deprecated
        public int getPort() {
            return this.port;
        }

        private Service(String localStackName, int port) {
            this.localStackName = localStackName;
            this.port = port;
        }

        public String getLocalStackName() {
            return this.localStackName;
        }
    }

    public static interface EnabledService {
        public static EnabledService named(String name) {
            return () -> name;
        }

        public String getName();

        default public int getPort() {
            return 4566;
        }
    }
}

