/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.voltron.proxy.client;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Map;
import org.terracotta.connection.entity.Entity;
import org.terracotta.entity.EntityClientEndpoint;
import org.terracotta.voltron.proxy.Codec;
import org.terracotta.voltron.proxy.CommonProxyFactory;
import org.terracotta.voltron.proxy.ProxyEntityMessage;
import org.terracotta.voltron.proxy.ProxyEntityResponse;
import org.terracotta.voltron.proxy.client.ServerMessageAware;
import org.terracotta.voltron.proxy.client.VoltronProxyInvocationHandler;

public class ClientProxyFactory {
    public static <T extends Entity & ServerMessageAware> T createEntityProxy(Class<T> clientType, Class<? super T> type, EntityClientEndpoint<ProxyEntityMessage, ProxyEntityResponse> entityClientEndpoint, Class<?>[] messageTypes, Codec codec) {
        return (T)((Entity)ClientProxyFactory.createProxy(clientType, type, entityClientEndpoint, messageTypes, codec));
    }

    public static <T> T createProxy(Class<T> clientType, Class<? super T> type, EntityClientEndpoint<ProxyEntityMessage, ProxyEntityResponse> entityClientEndpoint, Class<?>[] messageTypes, Codec codec) {
        if (entityClientEndpoint == null) {
            throw new NullPointerException("EntityClientEndpoint has to be provided!");
        }
        if (!type.isInterface()) {
            throw new IllegalArgumentException("We only proxy interfaces!");
        }
        Class[] interfaces = messageTypes == null || messageTypes.length == 0 ? new Class[]{clientType, Entity.class} : new Class[]{clientType, Entity.class, ServerMessageAware.class};
        return clientType.cast(Proxy.newProxyInstance(Entity.class.getClassLoader(), interfaces, (InvocationHandler)new VoltronProxyInvocationHandler(entityClientEndpoint, CommonProxyFactory.invert((Map)CommonProxyFactory.createResponseTypeMappings(type, (Class[])messageTypes)).values(), codec)));
    }
}

