/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.cache.serialization;

import com.tc.object.ClientObjectManager;
import com.tc.object.TCObject;
import com.tc.object.TraversedReferences;
import com.tc.object.applicator.BaseApplicator;
import com.tc.object.bytecode.TransparentAccess;
import com.tc.object.dna.api.DNA;
import com.tc.object.dna.api.DNACursor;
import com.tc.object.dna.api.DNAEncoding;
import com.tc.object.dna.api.DNAWriter;
import com.tc.object.dna.api.PhysicalAction;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SerializedEntryApplicator
extends BaseApplicator {
    public static final String SERIALIZED_ENTRY = "org.terracotta.cache.serialization.SerializedEntry";
    public static final String ABSTRACT_TIMESTAMPED_VALUE = "org.terracotta.cache.value.AbstractTimestampedValue";
    private static final String VALUE_FIELD = "org.terracotta.cache.serialization.SerializedEntry.value";
    private static final String CREATE_TIME_FIELD = "org.terracotta.cache.serialization.SerializedEntry.createTime";
    private static final String LAST_ACCESS_TIME_FIELD = "org.terracotta.cache.value.AbstractTimestampedValue.lastAccessedTime";

    public SerializedEntryApplicator(DNAEncoding encoding) {
        super(encoding);
    }

    public void dehydrate(ClientObjectManager objMgr, TCObject tco, DNAWriter writer, Object pojo) {
        Map<String, Object> values = this.getAllFields(pojo);
        writer.addEntireArray(SerializedEntryApplicator.get(values, VALUE_FIELD));
        writer.addPhysicalAction(CREATE_TIME_FIELD, SerializedEntryApplicator.get(values, CREATE_TIME_FIELD));
        writer.addPhysicalAction(LAST_ACCESS_TIME_FIELD, SerializedEntryApplicator.get(values, LAST_ACCESS_TIME_FIELD));
    }

    protected static Object get(Map<String, Object> values, String field) {
        Object value = values.get(field);
        if (value == null) {
            throw new AssertionError((Object)("null value for field " + field));
        }
        return value;
    }

    public Object getNewInstance(ClientObjectManager objMgr, DNA dna) {
        throw new UnsupportedOperationException();
    }

    public TraversedReferences getPortableObjects(Object pojo, TraversedReferences addTo) {
        return addTo;
    }

    Map<String, Object> getAllFields(Object pojo) {
        TransparentAccess ta = (TransparentAccess)pojo;
        HashMap<String, Object> values = new HashMap<String, Object>();
        ta.__tc_getallfields(values);
        return values;
    }

    public void hydrate(ClientObjectManager objMgr, TCObject tco, DNA dna, Object pojo) throws IOException, ClassNotFoundException {
        DNACursor cursor = dna.getCursor();
        while (cursor.next(this.encoding)) {
            PhysicalAction a = cursor.getPhysicalAction();
            if (a.isEntireArray()) {
                tco.setValue(VALUE_FIELD, a.getObject());
                continue;
            }
            tco.setValue(a.getFieldName(), a.getObject());
        }
    }
}

