/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.cache.serialization;

import com.tc.object.bytecode.Clearable;
import com.tc.object.bytecode.ManagerUtil;
import com.tc.object.bytecode.NotClearable;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.terracotta.collections.ConcurrentDistributedMap;
import org.terracotta.collections.LockStrategy;
import org.terracotta.collections.LockType;
import org.terracotta.collections.NullLockStrategy;

class ObjectStreamClassSerializer
implements NotClearable {
    private static final Lookup DEFAULT_LOOKUP = ObjectStreamClassSerializer.obtainLookup();
    private final Object writeLock = new Object();
    private final ConcurrentDistributedMap<String, Object> mappings;
    private int nextMapping = 0;
    private volatile transient Map<Integer, ObjectStreamClass> localCache = new ConcurrentHashMap<Integer, ObjectStreamClass>();
    private volatile transient Lookup lookup;
    private final boolean locked;

    ObjectStreamClassSerializer() {
        this(true);
    }

    ObjectStreamClassSerializer(boolean locked) {
        this.locked = locked;
        this.mappings = locked ? new ConcurrentDistributedMap() : new ConcurrentDistributedMap(LockType.WRITE, (LockStrategy)new NullLockStrategy());
        this.initialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMappingFor(String className) {
        Integer value = (Integer)this.mappings.unsafeGet((Object)className);
        if (value != null) {
            return value;
        }
        if (this.locked) {
            ManagerUtil.monitorEnter((Object)this.writeLock, (int)2);
        }
        try {
            value = (Integer)this.mappings.get((Object)className);
            if (value != null) {
                int n = value;
                return n;
            }
            value = this.nextMapping++;
            this.put(className, value);
            this.put(value.toString(), className);
        }
        finally {
            if (this.locked) {
                ManagerUtil.monitorExit((Object)this.writeLock, (int)2);
            }
        }
        return value;
    }

    public ObjectStreamClass getObjectStreamClassFor(int mapping, ClassLoader loader) throws ClassNotFoundException {
        ObjectStreamClass osc = this.localCache.get(mapping);
        if (osc == null) {
            String className = (String)this.mappings.get((Object)Integer.toString(mapping));
            if (className == null) {
                throw new AssertionError((Object)("missing reverse mapping for " + mapping));
            }
            Class<?> c = loader == null ? Class.forName(className) : Class.forName(className, false, loader);
            osc = this.lookup.lookup(c);
            this.localCache.put(mapping, osc);
        }
        return osc;
    }

    public void initialize() {
        this.lookup = DEFAULT_LOOKUP;
        this.localCache = new ConcurrentHashMap<Integer, ObjectStreamClass>();
        for (Map map : this.mappings.getConstituentMaps()) {
            if (!(map instanceof Clearable)) continue;
            ((Clearable)map).setEvictionEnabled(false);
        }
    }

    private void put(String key, Object value) {
        Object prev = this.mappings.put((Object)key, value);
        if (prev != null) {
            throw new AssertionError((Object)("replaced mapping for key (" + key + "), old value = " + prev + ", new value = " + value));
        }
    }

    void forceSlowLookup() {
        this.lookup = new SlowLookup();
        this.localCache.clear();
    }

    private static Lookup obtainLookup() {
        try {
            Method lookupMethod = ObjectStreamClass.class.getMethod("lookupAny", Class.class);
            return new LookupAny(lookupMethod);
        }
        catch (Exception e) {
            try {
                Method method = ObjectStreamClass.class.getDeclaredMethod("lookup", Class.class, Boolean.TYPE);
                method.setAccessible(true);
                return new PrivateLookup(method);
            }
            catch (Exception exception) {
                return new SlowLookup();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SlowLookup
    implements Lookup {
        private SlowLookup() {
        }

        @Override
        public ObjectStreamClass lookup(Class<?> cl) {
            try {
                OOS oos = new OOS(cl);
                oos.writeObject(cl);
                oos.close();
                return oos.getDescriptor();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        private static class NullOutputStream
        extends OutputStream {
            NullOutputStream() {
            }

            public void write(int b) {
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class OOS
        extends ObjectOutputStream {
            private final Class<?> cl;
            private ObjectStreamClass desc;

            public OOS(Class<?> cl) throws IOException {
                super(new NullOutputStream());
                this.cl = cl;
            }

            ObjectStreamClass getDescriptor() {
                if (this.desc == null) {
                    throw new IllegalStateException("Descriptor never set for " + this.cl);
                }
                return this.desc;
            }

            @Override
            protected void writeClassDescriptor(ObjectStreamClass osc) throws IOException {
                if (osc.forClass().equals(this.cl)) {
                    this.desc = osc;
                }
                super.writeClassDescriptor(osc);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PrivateLookup
    implements Lookup {
        private final Method method;

        PrivateLookup(Method method) {
            this.method = method;
        }

        @Override
        public ObjectStreamClass lookup(Class<?> cl) {
            try {
                return (ObjectStreamClass)this.method.invoke(null, cl, Boolean.TRUE);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LookupAny
    implements Lookup {
        private final Method lookupMethod;

        LookupAny(Method lookupMethod) {
            this.lookupMethod = lookupMethod;
        }

        @Override
        public ObjectStreamClass lookup(Class<?> cl) {
            try {
                return (ObjectStreamClass)this.lookupMethod.invoke(null, cl);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface Lookup {
        public ObjectStreamClass lookup(Class<?> var1);
    }
}

