/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.cache.serialization;

import com.tc.object.bytecode.NotClearable;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import org.terracotta.cache.serialization.ObjectStreamClassSerializer;
import org.terracotta.cache.serialization.SerializationStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DsoSerializationStrategy<T>
implements SerializationStrategy<T>,
NotClearable {
    protected static final byte HIGH_BIT = -128;
    protected final ObjectStreamClassSerializer oscSerializer;

    public DsoSerializationStrategy() {
        this(true);
    }

    public DsoSerializationStrategy(boolean internalLocking) {
        this.oscSerializer = new ObjectStreamClassSerializer(internalLocking);
    }

    @Override
    public T deserialize(byte[] data) throws IOException, ClassNotFoundException {
        return (T)new OIS(new ByteArrayInputStream(data), this.oscSerializer).readObject();
    }

    @Override
    public T deserialize(byte[] data, ClassLoader loader) throws IOException, ClassNotFoundException {
        return (T)new OIS(new ByteArrayInputStream(data), this.oscSerializer, loader).readObject();
    }

    @Override
    public byte[] serialize(T value) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        OOS oos = new OOS(baos, this.oscSerializer);
        oos.writeObject(value);
        oos.close();
        return baos.toByteArray();
    }

    @Override
    public String generateStringKeyFor(Object key) throws IOException {
        if (key instanceof String) {
            return (String)key;
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        OOS oos = new OOS(bos, this.oscSerializer);
        this.writeStringKey(key, oos);
        oos.close();
        return bos.toString(0);
    }

    protected void writeStringKey(Object key, ObjectOutputStream oos) throws IOException {
        oos.writeObject(key);
    }

    void forceSlowLookup() {
        this.oscSerializer.forceSlowLookup();
    }

    protected static final int decodeInt(InputStream is) throws IOException {
        int rv = 0;
        int length = is.read();
        if ((length & 0xFFFFFF80) > 0) {
            if ((length &= 0x7F) == 0 || length > 4) {
                throw new IOException("invalid length: " + length);
            }
            for (int i = 0; i < length; ++i) {
                int l = is.read() & 0xFF;
                rv |= l << 8 * (length - 1 - i);
            }
            if (rv < 0) {
                throw new IOException("invalid value: " + rv);
            }
        } else {
            rv = length & 0xFF;
        }
        return rv;
    }

    protected static final void encodeInt(OutputStream os, int value) throws IOException {
        if (value < 0) {
            throw new IOException("cannot encode negative values");
        }
        if (value < 128) {
            os.write(value);
        } else if (value <= 255) {
            os.write(-127);
            os.write(value);
        } else if (value <= 65535) {
            os.write(-126);
            os.write(value >> 8 & 0xFF);
            os.write(value & 0xFF);
        } else if (value <= 0xFFFFFF) {
            os.write(-125);
            os.write(value >> 16 & 0xFF);
            os.write(value >> 8 & 0xFF);
            os.write(value & 0xFF);
        } else {
            os.write(-124);
            os.write(value >> 24 & 0xFF);
            os.write(value >> 16 & 0xFF);
            os.write(value >> 8 & 0xFF);
            os.write(value & 0xFF);
        }
    }

    protected static class OOS
    extends ObjectOutputStream {
        private final ObjectStreamClassSerializer oscSerializer;

        public OOS(OutputStream out, ObjectStreamClassSerializer oscSerializer) throws IOException {
            super(out);
            this.oscSerializer = oscSerializer;
        }

        protected void writeClassDescriptor(ObjectStreamClass desc) throws IOException {
            String name = desc.getName();
            int code = this.oscSerializer.getMappingFor(name);
            DsoSerializationStrategy.encodeInt(this, code);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class OIS
    extends ObjectInputStream {
        private final ObjectStreamClassSerializer oscSerializer;
        private final ClassLoader loader;

        public OIS(InputStream in, ObjectStreamClassSerializer oscSerializer) throws IOException {
            this(in, oscSerializer, null);
        }

        public OIS(InputStream in, ObjectStreamClassSerializer oscSerializer, ClassLoader loader) throws IOException {
            super(in);
            this.oscSerializer = oscSerializer;
            this.loader = loader;
        }

        @Override
        protected ObjectStreamClass readClassDescriptor() throws IOException, ClassNotFoundException {
            int code = DsoSerializationStrategy.decodeInt(this);
            return this.oscSerializer.getObjectStreamClassFor(code, this.loader);
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
            if (this.loader == null) {
                return super.resolveClass(desc);
            }
            return Class.forName(desc.getName(), false, this.loader);
        }
    }
}

