/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.cache.impl;

import java.util.ArrayList;
import java.util.List;
import org.terracotta.cache.CacheConfig;
import org.terracotta.cache.CacheConfigFactory;
import org.terracotta.cache.DistributedCache;
import org.terracotta.cache.evictor.CapacityEvictionPolicyData;
import org.terracotta.cache.evictor.LFUCapacityEvictionPolicyData;
import org.terracotta.cache.impl.DistributedCacheImpl;
import org.terracotta.cache.impl.ImmutableConfig;
import org.terracotta.cache.impl.LocalCache;
import org.terracotta.cache.logging.ConfigChangeListener;
import org.terracotta.cache.logging.TCLoggerConfigChangeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MutableConfig
implements CacheConfig {
    private static final boolean DSO_ACTIVE = Boolean.getBoolean("tc.active");
    private String name = "Distributed Cache";
    private int maxTTISeconds = 0;
    private int maxTTLSeconds = 0;
    private boolean orphanEvictionEnabled = true;
    private int orphanEvictionPeriod = 4;
    private boolean loggingEnabled = false;
    private int targetMaxInMemoryCount = 0;
    private int targetMaxTotalCount = 0;
    private transient List<ConfigChangeListener> configListeners = new ArrayList<ConfigChangeListener>();
    private CapacityEvictionPolicyData.Factory capacityEvictionPolicyDataFactory = new LFUCapacityEvictionPolicyData.Factory();
    private volatile transient CacheConfig snapshot;

    public void initializeOnLoad() {
        this.configListeners = new ArrayList<ConfigChangeListener>();
        this.refresh();
        this.registerTCLoggerIfActive();
    }

    public MutableConfig() {
        this.refresh();
        this.registerTCLoggerIfActive();
    }

    public MutableConfig(String name, boolean loggingEnabled, int maxTTISeconds, int maxTTLSeconds, boolean orphanEvictionEnabled, int orphanEvictionPeriod, int targetMaxInMemoryCount, int targetMaxTotalCount, CapacityEvictionPolicyData.Factory capacityEvictionPolicyDataFactory) {
        this.name = name;
        this.loggingEnabled = loggingEnabled;
        this.maxTTISeconds = maxTTISeconds;
        this.maxTTLSeconds = maxTTLSeconds;
        this.orphanEvictionEnabled = orphanEvictionEnabled;
        this.orphanEvictionPeriod = orphanEvictionPeriod;
        this.targetMaxInMemoryCount = targetMaxInMemoryCount;
        this.targetMaxTotalCount = targetMaxTotalCount;
        this.capacityEvictionPolicyDataFactory = capacityEvictionPolicyDataFactory;
        this.refresh();
        this.registerTCLoggerIfActive();
    }

    private void registerTCLoggerIfActive() {
        if (DSO_ACTIVE) {
            this.addConfigChangeListener(new TCLoggerConfigChangeListener());
        }
    }

    @Override
    public String getName() {
        return this.snapshot.getName();
    }

    @Override
    public int getMaxTTISeconds() {
        return this.snapshot.getMaxTTISeconds();
    }

    @Override
    public int getMaxTTLSeconds() {
        return this.snapshot.getMaxTTLSeconds();
    }

    @Override
    public boolean isOrphanEvictionEnabled() {
        return this.snapshot.isOrphanEvictionEnabled();
    }

    @Override
    public int getOrphanEvictionPeriod() {
        return this.snapshot.getOrphanEvictionPeriod();
    }

    @Override
    public boolean isLoggingEnabled() {
        return this.snapshot.isLoggingEnabled();
    }

    @Override
    public int getTargetMaxInMemoryCount() {
        return this.snapshot.getTargetMaxInMemoryCount();
    }

    @Override
    public int getTargetMaxTotalCount() {
        return this.snapshot.getTargetMaxTotalCount();
    }

    @Override
    public CapacityEvictionPolicyData.Factory getCapacityEvictionPolicyDataFactory() {
        return this.snapshot.getCapacityEvictionPolicyDataFactory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableConfig setMaxTTISeconds(int maxTTISeconds) {
        if (maxTTISeconds < 0) {
            throw new IllegalArgumentException("Max TTI must be >= 0");
        }
        MutableConfig mutableConfig = this;
        synchronized (mutableConfig) {
            this.maxTTISeconds = maxTTISeconds;
            this.notifyAll();
        }
        this.refresh();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableConfig setMaxTTLSeconds(int maxTTLSeconds) {
        if (maxTTLSeconds < 0) {
            throw new IllegalArgumentException("Max TTL must be >= 0");
        }
        MutableConfig mutableConfig = this;
        synchronized (mutableConfig) {
            this.maxTTLSeconds = maxTTLSeconds;
            this.notifyAll();
        }
        this.refresh();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableConfig setOrphanEvictionEnabled(boolean orphanEvictionEnabled) {
        MutableConfig mutableConfig = this;
        synchronized (mutableConfig) {
            this.orphanEvictionEnabled = orphanEvictionEnabled;
            this.notifyAll();
        }
        this.refresh();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableConfig setOrphanEvictionPeriod(int orphanEvictionPeriod) {
        MutableConfig mutableConfig = this;
        synchronized (mutableConfig) {
            this.orphanEvictionPeriod = orphanEvictionPeriod;
            this.notifyAll();
        }
        this.refresh();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableConfig setLoggingEnabled(boolean loggingEnabled) {
        MutableConfig mutableConfig = this;
        synchronized (mutableConfig) {
            this.loggingEnabled = loggingEnabled;
            this.notifyAll();
        }
        this.refresh();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableConfig setTargetMaxInMemoryCount(int targetMaxInMemoryCount) {
        MutableConfig mutableConfig = this;
        synchronized (mutableConfig) {
            this.targetMaxInMemoryCount = targetMaxInMemoryCount;
            this.notifyAll();
        }
        this.refresh();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableConfig setTargetMaxTotalCount(int targetMaxTotalCount) {
        MutableConfig mutableConfig = this;
        synchronized (mutableConfig) {
            this.targetMaxTotalCount = targetMaxTotalCount;
            this.notifyAll();
        }
        this.refresh();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableConfig setName(String name) {
        if (name == null) {
            throw new NullPointerException("Name cannot be null");
        }
        MutableConfig mutableConfig = this;
        synchronized (mutableConfig) {
            this.name = name;
            this.notifyAll();
        }
        this.refresh();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CacheConfig setCapacityEvictionPolicyDataFactory(CapacityEvictionPolicyData.Factory factory) {
        if (factory == null) {
            throw new NullPointerException("capacityEvictionPolicyDataFactory cannot be null");
        }
        MutableConfig mutableConfig = this;
        synchronized (mutableConfig) {
            this.capacityEvictionPolicyDataFactory = factory;
            this.notifyAll();
        }
        this.refresh();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitForChange(long maxWait) {
        MutableConfig mutableConfig = this;
        synchronized (mutableConfig) {
            if (this.refresh()) {
                return;
            }
            try {
                this.wait(maxWait);
            }
            catch (InterruptedException e) {
            }
            finally {
                this.refresh();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean refresh() {
        MutableConfig mutableConfig = this;
        synchronized (mutableConfig) {
            CacheConfig oldSnapshot = this.snapshot;
            this.snapshot = new ImmutableConfig(this.name, this.loggingEnabled, this.maxTTISeconds, this.maxTTLSeconds, this.orphanEvictionEnabled, this.orphanEvictionPeriod, this.targetMaxInMemoryCount, this.targetMaxTotalCount, this.capacityEvictionPolicyDataFactory);
            if (oldSnapshot != null) {
                this.fireChangeEventIfNeeded("name", oldSnapshot.getName(), this.name);
                this.fireChangeEventIfNeeded("loggingEnabled", oldSnapshot.isLoggingEnabled(), this.loggingEnabled);
                this.fireChangeEventIfNeeded("maxTTISeconds", oldSnapshot.getMaxTTISeconds(), this.maxTTISeconds);
                this.fireChangeEventIfNeeded("maxTTLSeconds", oldSnapshot.getMaxTTLSeconds(), this.maxTTLSeconds);
                this.fireChangeEventIfNeeded("orphanEvictionEnabled", oldSnapshot.isOrphanEvictionEnabled(), this.orphanEvictionEnabled);
                this.fireChangeEventIfNeeded("orphanEvictionPeriod", oldSnapshot.getOrphanEvictionPeriod(), this.orphanEvictionPeriod);
                this.fireChangeEventIfNeeded("targetMaxInMemoryCount", oldSnapshot.getTargetMaxInMemoryCount(), this.targetMaxInMemoryCount);
                this.fireChangeEventIfNeeded("targetMaxTotalCount", oldSnapshot.getTargetMaxTotalCount(), this.targetMaxTotalCount);
                this.fireChangeEventIfNeeded("capacityEvictionPolicyDataFactory", oldSnapshot.getCapacityEvictionPolicyDataFactory(), this.capacityEvictionPolicyDataFactory);
            }
            return !this.snapshot.equals(oldSnapshot);
        }
    }

    @Override
    public <K, V> DistributedCache<K, V> newCache() {
        MutableConfig copyConfig = new MutableConfig(this.name, this.loggingEnabled, this.maxTTISeconds, this.maxTTLSeconds, this.orphanEvictionEnabled, this.orphanEvictionPeriod, this.targetMaxInMemoryCount, this.targetMaxTotalCount, this.capacityEvictionPolicyDataFactory);
        if (CacheConfigFactory.DSO_ACTIVE) {
            return new DistributedCacheImpl(copyConfig);
        }
        return new LocalCache(copyConfig);
    }

    public boolean equals(Object o) {
        if (!(o instanceof MutableConfig)) {
            return false;
        }
        MutableConfig config = (MutableConfig)o;
        return this.getName().equals(config.getName()) && this.getMaxTTISeconds() == config.getMaxTTISeconds() && this.getMaxTTLSeconds() == config.getMaxTTLSeconds() && this.isOrphanEvictionEnabled() == config.isOrphanEvictionEnabled() && this.getOrphanEvictionPeriod() == config.getOrphanEvictionPeriod() && this.isLoggingEnabled() == config.isLoggingEnabled() && this.getTargetMaxInMemoryCount() == config.getTargetMaxInMemoryCount() && this.getTargetMaxTotalCount() == config.getTargetMaxTotalCount();
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    private void fireConfigChangeEvent(String configName, Object oldValue, Object newValue) {
        for (ConfigChangeListener ccl : this.configListeners.toArray(new ConfigChangeListener[0])) {
            ccl.configChanged(this.name, configName, oldValue, newValue);
        }
    }

    private void fireChangeEventIfNeeded(String configName, Object oldValue, Object newValue) {
        if (oldValue != null && !oldValue.equals(newValue)) {
            this.fireConfigChangeEvent(configName, oldValue, newValue);
        }
    }

    public synchronized void addConfigChangeListener(ConfigChangeListener ccl) {
        this.configListeners.add(ccl);
    }

    public synchronized void removeConfigChangeListener(ConfigChangeListener ccl) {
        this.configListeners.remove(ccl);
    }
}

