/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.cache.evictor;

import com.tc.cluster.DsoCluster;
import com.tc.injection.annotations.InjectedDsoInstance;
import com.tc.logging.TCLogger;
import com.tc.object.bytecode.ManagerUtil;
import com.tc.util.Assert;
import org.terracotta.cache.CacheConfig;
import org.terracotta.cache.evictor.Evictable;
import org.terracotta.cache.evictor.EvictionListener;
import org.terracotta.cache.evictor.EvictorLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrphanEvictionListener<K>
implements EvictionListener {
    private static volatile TCLogger logger;
    private final CacheConfig config;
    private final Evictable<K> store;
    private final EvictorLock orphanEvictorLock;
    private transient boolean isOrphanEvictor;
    private transient int evictionCount;
    @InjectedDsoInstance
    private DsoCluster clusterInfo;

    public OrphanEvictionListener(CacheConfig config, Evictable<K> store, EvictorLock orphanEvictorLock) {
        this.config = config;
        if (config.isOrphanEvictionEnabled()) {
            Assert.eval((config.getOrphanEvictionPeriod() > 0 ? 1 : 0) != 0);
        }
        this.store = store;
        this.orphanEvictorLock = orphanEvictorLock;
    }

    private static TCLogger getLogger() {
        if (logger == null) {
            logger = ManagerUtil.getLogger((String)"com.tc.dmap.eviction");
        }
        return logger;
    }

    private void log(String message) {
        if (this.config.isLoggingEnabled()) {
            OrphanEvictionListener.getLogger().info((Object)("[" + ManagerUtil.getClientID() + "] " + message));
        }
    }

    @Override
    public void startLocalEviction() {
        if (this.config.isOrphanEvictionEnabled() && !this.isOrphanEvictor) {
            if (this.orphanEvictorLock.tryLock()) {
                this.isOrphanEvictor = true;
                this.log("Elected to be orphan evictor");
            } else {
                this.isOrphanEvictor = false;
            }
        }
        this.log("Local eviction started");
    }

    @Override
    public void endLocalEviction() {
        this.log("Local eviction finished");
        if (!this.config.isOrphanEvictionEnabled() || !this.isOrphanEvictor || this.config.getMaxTTISeconds() <= 0 && this.config.getMaxTTLSeconds() <= 0) {
            return;
        }
        boolean isTimeForOrphanEviction = this.incrementEvictionCounter();
        if (isTimeForOrphanEviction) {
            this.log("Running orphan eviction (evictionCount = " + this.evictionCount + ", orphanEvictionPeriod = " + this.config.getOrphanEvictionPeriod() + ")");
            if (this.clusterInfo != null) {
                this.store.evictOrphanElements(this.clusterInfo);
            }
        } else {
            this.log("Not running orphan eviction (evictionCount = " + this.evictionCount + ", orphanEvictionPeriod = " + this.config.getOrphanEvictionPeriod() + ")");
        }
    }

    private boolean incrementEvictionCounter() {
        boolean isTimeForOrphanEviction;
        ++this.evictionCount;
        boolean bl = isTimeForOrphanEviction = this.evictionCount >= this.config.getOrphanEvictionPeriod();
        if (isTimeForOrphanEviction) {
            this.evictionCount = 0;
        }
        return isTimeForOrphanEviction;
    }

    @Override
    public void onShutdown() {
        if (this.isOrphanEvictor) {
            this.isOrphanEvictor = false;
            this.orphanEvictorLock.unlock();
        }
    }
}

