/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.cache.evictor;

import com.tc.stats.counter.CounterConfig;
import com.tc.stats.counter.CounterManager;
import com.tc.stats.counter.CounterManagerImpl;
import com.tc.stats.counter.sampled.SampledCounter;
import com.tc.stats.counter.sampled.SampledCounterConfig;
import org.terracotta.cache.evictor.EvictionStatisticsSampled;

class EvictionStatisticsSampledDSO
implements EvictionStatisticsSampled {
    private final CounterManager counterManager = new CounterManagerImpl();
    private final SampledCounterConfig sampledCounterConfig = new SampledCounterConfig(1, 300, true, 0L);
    private volatile SampledCounter examinedSample;
    private volatile SampledCounter evictedSample;

    EvictionStatisticsSampledDSO() {
    }

    public void reset() {
        this.shutdown();
        this.examinedSample = (SampledCounter)this.counterManager.createCounter((CounterConfig)this.sampledCounterConfig);
        this.evictedSample = (SampledCounter)this.counterManager.createCounter((CounterConfig)this.sampledCounterConfig);
    }

    public void shutdown() {
        if (this.examinedSample != null) {
            this.examinedSample.shutdown();
        }
        if (this.evictedSample != null) {
            this.evictedSample.shutdown();
        }
    }

    public void increment(long additionalExamined, long additionalEvicted) {
        if (this.examinedSample != null) {
            this.examinedSample.increment(additionalExamined);
        }
        if (this.evictedSample != null) {
            this.evictedSample.increment(additionalEvicted);
        }
    }

    public long getExaminedMostRecentSample() {
        if (this.examinedSample != null) {
            return this.examinedSample.getMostRecentSample().getCounterValue();
        }
        return 0L;
    }

    public long getEvictedMostRecentSample() {
        if (this.evictedSample != null) {
            return this.evictedSample.getMostRecentSample().getCounterValue();
        }
        return 0L;
    }
}

