/*
 * All content copyright Terracotta, Inc., unless otherwise indicated. All rights reserved.
 */
package org.terracotta.cache.value;

import org.terracotta.cache.evictor.CapacityEvictionPolicyData;
import org.terracotta.cache.evictor.NullCapacityEvictionPolicyData;

/**
 * Abstract base class for timestamped map entries. This class defines the timestamp manipulation logic and locking that
 * should be common for all entries
 */
public abstract class AbstractTimestampedValue<V> extends AbstractStatelessTimestampedValue<V> {

  /**
   * Last time when this item was used guarded by synchronized(this) with terracotta auto-locks time is seconds since
   * the epoch (System.currentTimeMillis() / 1000) for example)
   */
  private int                                           lastAccessedTime;

  private volatile transient CapacityEvictionPolicyData capacityEvictionPolicyData = NullCapacityEvictionPolicyData.SINGLE_INSTANCE;

  protected AbstractTimestampedValue() {
    // default constructor
  }

  public void setCapacityEvictionPolicyData(final CapacityEvictionPolicyData capacityEvictionPolicy) {
    this.capacityEvictionPolicyData = capacityEvictionPolicy;
  }

  public CapacityEvictionPolicyData getCapacityEvictionPolicyData() {
    return capacityEvictionPolicyData;
  }

  protected final CapacityEvictionPolicyData fastGetCapacityEvictionPolicyData() {
    return capacityEvictionPolicyData;
  }

  public synchronized int getLastAccessedTime() {
    return this.lastAccessedTime;
  }

  protected void setLastAccessedTimeInternal(final int usedAtTime) {
    this.lastAccessedTime = usedAtTime;
  }

}
