/*
 * All content copyright (c) Terracotta, Inc., except as may otherwise be noted in a separate copyright notice. All
 * rights reserved.
 */
package org.terracotta.cache.serialization;

import java.io.IOException;

public interface SerializationStrategy<T> {

  T deserialize(byte[] data) throws IOException, ClassNotFoundException;

  T deserialize(byte[] data, ClassLoader loader) throws IOException, ClassNotFoundException;

  byte[] serialize(T value) throws IOException;

  String generateStringKeyFor(Object key) throws IOException;
}
