/*
 * All content copyright Terracotta, Inc., unless otherwise indicated. All rights reserved.
 */
package org.terracotta.cache.evictor;

import java.util.concurrent.atomic.AtomicInteger;

/**
 * @author abhi.sanoujam
 */
public class LRUCapacityEvictionPolicyData implements CapacityEvictionPolicyData {

  public static class Factory implements CapacityEvictionPolicyData.Factory {
    public CapacityEvictionPolicyData newCapacityEvictionPolicyData() {
      return new LRUCapacityEvictionPolicyData();
    }

    public boolean isProductOfFactory(CapacityEvictionPolicyData capacityEvictionPolicyData) {
      return (capacityEvictionPolicyData instanceof LRUCapacityEvictionPolicyData);
    }

  }

  private final AtomicInteger lastUsedTime = new AtomicInteger();

  public void markUsed(int usedAtTime) {
    lastUsedTime.set(usedAtTime);
  }

  public int compareTo(CapacityEvictionPolicyData other) {
    if (other == null) {
      return 1;
    } else {
      if (!(other instanceof LRUCapacityEvictionPolicyData)) return 0;
      LRUCapacityEvictionPolicyData o = (LRUCapacityEvictionPolicyData) other;
      return (lastUsedTime.get() - o.lastUsedTime.get());
    }
  }

  @Override
  public String toString() {
    return "LRUCapacityEvictionPolicyData {lastUsedTime = " + lastUsedTime.get() + "}";
  }

}
