/*
 * All content copyright (c) 2003-2009 Terracotta, Inc., except as may otherwise be noted in a separate copyright
 * notice. All rights reserved.
 */
package org.terracotta.cache.evictor;

import com.tc.cluster.DsoCluster;

/**
 * The {@link Evictor} works against this interface to trigger local and orphan eviction. The Evictable implementation
 * is most commonly a Map where the parameter here is the key type. It could theoretically also work on a partial List
 * or array where K is the item type.
 *
 * @param <K> The Evictable item type, usually the key type of a Map
 */
public interface Evictable<K> {

  /**
   * Trigger to walk through the local elements, look for expired elements, and evict them.
   */
  void evictExpiredLocalElements();

  /**
   * Trigger to walk through the specified set of orphaned elements, check whether they have expired, and evict them
   * from the store.
   *
   * @param clusterInfo The dso cluster info which can be used to obtain the orphaned element list
   */
  void evictOrphanElements(DsoCluster clusterInfo);

  /**
   * Toggle statistics being enabled or not. When statistics are disabled, the already accumulated data will be reset.
   *
   * @param enabled {@code true} to enable statistics; and {@code false) to disable them
   */
  void setStatisticsEnabled(boolean enabled);

  /**
   * Returns whether statistics are enabled.
   *
   * @return {@code true}when statistics are enabled; and {@code false} otherwise
   */
  boolean isStatisticsEnabled();

  /**
   * Retrieve the statistics for the current JVM.
   *
   *  @return the statistics instance for the current JVM, statistics aren't shared across the cluster
   */
  EvictionStatistics getStatistics();
}
