/*
 * All content copyright Terracotta, Inc., unless otherwise indicated. All rights reserved.
 */
package org.terracotta.cache.activator;

import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.terracotta.cache.serialization.SerializedEntryApplicator;
import org.terracotta.modules.configuration.TerracottaConfiguratorModule;

import com.tc.object.config.ChangeApplicatorSpec;
import org.terracotta.cache.serialization.CustomLifespanSerializedEntryApplicator;

public class DistributedCacheActivator extends TerracottaConfiguratorModule {

  @Override
  protected void addInstrumentation(final BundleContext context) {
    super.addInstrumentation(context);

    Bundle bundle = getThisBundle();

    // Needed when standalone hibernate-cache is used
    addExportedBundleClass(bundle, "org.terracotta.cache.DistributedCache");
    addExportedBundleClass(bundle, "org.terracotta.cache.CacheConfig");
    addExportedBundleClass(bundle, "org.terracotta.cache.TimestampedValue");
    addExportedBundleClass(bundle, "org.terracotta.cache.evictor.Evictable");
    addExportedBundleClass(bundle, "org.terracotta.cache.evictor.EvictionStatistics");
    addExportedBundleClass(bundle, "org.terracotta.cache.CacheConfigFactory");
    addExportedBundleClass(bundle, "org.terracotta.cache.evictor.EvictionStatisticsSampled");
    addExportedBundleClass(bundle, "org.terracotta.cache.evictor.EvictionStatisticsSampledDSO");
    addExportedBundleClass(bundle, "org.terracotta.cache.evictor.CapacityEvictionPolicyData");
    addExportedBundleClass(bundle, "org.terracotta.cache.evictor.CapacityEvictionPolicyData$Factory");

    addExportedTcJarClass("com.tc.stats.counter.Counter");
    addExportedTcJarClass("com.tc.stats.counter.CounterConfig");
    addExportedTcJarClass("com.tc.stats.counter.CounterImpl");
    addExportedTcJarClass("com.tc.stats.counter.CounterManager");
    addExportedTcJarClass("com.tc.stats.counter.CounterManagerImpl");
    addExportedTcJarClass("com.tc.stats.counter.sampled.SampledCounter");
    addExportedTcJarClass("com.tc.stats.counter.sampled.SampledCounterImpl$1");
    addExportedTcJarClass("com.tc.stats.counter.sampled.SampledCounterConfig");
    addExportedTcJarClass("com.tc.stats.counter.sampled.SampledCounterImpl");
    addExportedTcJarClass("com.tc.stats.counter.sampled.TimeStampedCounterValue");
    addExportedTcJarClass("com.tc.util.concurrent.CircularLossyQueue");

    this.configHelper.getOrCreateSpec("org.terracotta.cache.impl.DistributedCacheImpl")
        .setPostCreateMethod("startEviction");

    this.configHelper.getOrCreateSpec(SerializedEntryApplicator.SERIALIZED_ENTRY)
      .setChangeApplicatorSpec(new ChangeApplicatorSpec() {
        public Class getChangeApplicator(final Class target) {
          return SerializedEntryApplicator.class;
        }
      });
    this.configHelper.getOrCreateSpec(CustomLifespanSerializedEntryApplicator.CUSTOM_SERIALIZED_ENTRY)
      .setChangeApplicatorSpec(new ChangeApplicatorSpec() {
        public Class getChangeApplicator(Class type) {
          return CustomLifespanSerializedEntryApplicator.class;
        }
      });
  }
}
