/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dynamic_config.server.api;

import java.util.List;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.terracotta.dynamic_config.server.api.LicenseService;

public class LicenseParserDiscovery {
    private final ClassLoader classLoader;

    public LicenseParserDiscovery(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public Optional<LicenseService> find() {
        List services = StreamSupport.stream(ServiceLoader.load(LicenseService.class, this.classLoader).spliterator(), false).collect(Collectors.toList());
        if (services.isEmpty()) {
            return Optional.empty();
        }
        if (services.size() == 1) {
            return Optional.of(services.get(0));
        }
        throw new IllegalStateException("Found several implementations of " + LicenseService.class.getName() + " on classpath");
    }
}

