/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dynamic_config.cli.upgrade_tools.config_converter.xml;

import java.io.StringWriter;
import java.util.Optional;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class XmlUtility {
    public static Optional<String> getAttributeValue(Node node, String attributeName) {
        String retValue = null;
        NamedNodeMap attributeMap = node.getAttributes();
        for (int k = 0; k < attributeMap.getLength(); ++k) {
            Node attribute = attributeMap.item(k);
            if (!attributeName.equals(attribute.getLocalName())) continue;
            retValue = attribute.getNodeValue();
            break;
        }
        return retValue == null ? Optional.empty() : Optional.of(retValue);
    }

    public static Node getClonedParentDocFromRootNode(Node rootNode) {
        Node parentNode = rootNode.getParentNode();
        return parentNode.cloneNode(true);
    }

    public static void setAttribute(Node node, String attributeName, String attributeValue) {
        boolean match = false;
        NamedNodeMap attributeMap = node.getAttributes();
        for (int k = 0; k < attributeMap.getLength(); ++k) {
            Node attribute = attributeMap.item(k);
            if (!attributeName.equals(attribute.getLocalName())) continue;
            attribute.setNodeValue(attributeValue);
            match = true;
            break;
        }
        if (!match) {
            ((Element)node).setAttribute(attributeName, attributeValue);
        }
    }

    public static void removeNode(Node node, boolean removeEmptyParent) {
        Node removalNode = node;
        for (Node parentNode = node.getParentNode(); parentNode != null; parentNode = parentNode.getParentNode()) {
            parentNode.removeChild(removalNode);
            if (!removeEmptyParent || parentNode.getChildNodes().getLength() > 0) break;
            removalNode = parentNode;
        }
    }

    public static String getPrettyPrintableXmlString(Node doc) throws TransformerException {
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        StreamResult result = new StreamResult(new StringWriter());
        DOMSource source = new DOMSource(doc);
        transformer.transform(source, result);
        return result.getWriter().toString();
    }
}

