/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dynamic_config.cli.upgrade_tools.config_converter.xml;

import java.util.List;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.terracotta.dynamic_config.cli.upgrade_tools.config_converter.xml.TcConfigMapper;

public class TcConfigMapperDiscovery {
    private final ClassLoader classLoader;

    public TcConfigMapperDiscovery(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public Optional<TcConfigMapper> find() {
        List services = StreamSupport.stream(ServiceLoader.load(TcConfigMapper.class, this.classLoader).spliterator(), false).collect(Collectors.toList());
        if (services.isEmpty()) {
            return Optional.empty();
        }
        if (services.size() == 1) {
            TcConfigMapper service = (TcConfigMapper)services.get(0);
            service.init(this.classLoader);
            return Optional.of(service);
        }
        throw new IllegalStateException("Found several implementations of " + TcConfigMapper.class.getName() + " on classpath");
    }
}

