/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dynamic_config.cli.upgrade_tools.config_converter.exception;

import java.util.HashMap;
import java.util.Map;
import org.terracotta.dynamic_config.cli.upgrade_tools.config_converter.exception.ErrorCode;

public class ErrorCodeMapper {
    private static final Map<Long, ErrorDetail> ERROR_MAP = new HashMap<Long, ErrorDetail>();

    public static ErrorDetail getErrorCode(long projectSpecificErrorId) {
        ErrorDetail errorDetail = ERROR_MAP.get(projectSpecificErrorId);
        if (errorDetail == null) {
            errorDetail = new ErrorDetail(ErrorCode.UNKNOWN_ERROR, "Unknown error with id " + projectSpecificErrorId);
        }
        return errorDetail;
    }

    static {
        ERROR_MAP.put(800001L, new ErrorDetail(ErrorCode.MISMATCHED_DATA_DIR_NUMBERS, "Number of data directories defined in %s and in %s are not matching"));
        ERROR_MAP.put(800002L, new ErrorDetail(ErrorCode.PLATFORM_DATA_DIR_MISSING_IN_SOME_CONFIG_FILES, "Platform data root missing in one of %s %s"));
        ERROR_MAP.put(800003L, new ErrorDetail(ErrorCode.MISMATCHED_DATA_DIRS, "Data root directories are not same in %s and %s"));
        ERROR_MAP.put(800004L, new ErrorDetail(ErrorCode.NON_UNIQUE_PLATFORM_DATA_DIR_NAME, "Different data root directories are defined in %s %s"));
        ERROR_MAP.put(800005L, new ErrorDetail(ErrorCode.MULTIPLE_PLATFORM_DATA_DIRS, "Multiple data root directories are defined in %s"));
        ERROR_MAP.put(900001L, new ErrorDetail(ErrorCode.BOTH_WHITELIST_AND_DEPR_WHITELIST_PRESENT, "Both elements <whitelist> and <white-list>"));
        ERROR_MAP.put(900002L, new ErrorDetail(ErrorCode.MISMATCHED_SECURITY_CONFIGURATION, "Mismatched Security configuration in %s"));
        ERROR_MAP.put(700001L, new ErrorDetail(ErrorCode.MISMATCHED_CLIENT_LEASE_DURATION, "Mismatched lease configuration in %s"));
        ERROR_MAP.put(500001L, new ErrorDetail(ErrorCode.MISMATCHED_OFFHEAP_RESOURCE_NUMBERS, "Different number of off-heap resources are defined in %s and %s"));
        ERROR_MAP.put(500002L, new ErrorDetail(ErrorCode.MISMATCHED_OFFHEAP_RESOURCES, "Mismatched off-heap configuration in %s and %s"));
    }

    public static class ErrorDetail {
        final ErrorCode errorCode;
        final String errorMessage;

        ErrorDetail(ErrorCode errorCode, String errorMessage) {
            this.errorCode = errorCode;
            this.errorMessage = errorMessage;
        }

        public ErrorCode getErrorCode() {
            return this.errorCode;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }
    }
}

