/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dynamic_config.cli.upgrade_tools.config_converter.exception;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.terracotta.common.struct.Tuple2;
import org.terracotta.dynamic_config.cli.upgrade_tools.config_converter.exception.ErrorCode;

public class ConfigConversionException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private final Map<String, List<String>> parameters = new HashMap<String, List<String>>();
    private final ErrorCode errorCode;

    @SafeVarargs
    public ConfigConversionException(ErrorCode errorCode, String s, Tuple2<String, String> ... params) {
        super(s);
        this.errorCode = errorCode;
        if (params != null) {
            Stream<Tuple2<String, String>> paramStream = Arrays.stream(params);
            paramStream.forEach(param -> this.parameters.compute((String)param.getT1(), (key, value) -> {
                ArrayList<Object> retValue = value == null ? new ArrayList<Object>() : value;
                retValue.add(param.getT2());
                return retValue;
            }));
        }
    }

    public Map<String, List<String>> getParameters() {
        return Collections.unmodifiableMap(this.parameters);
    }

    public ErrorCode getErrorCode() {
        return this.errorCode;
    }
}

