/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dynamic_config.cli.upgrade_tools.config_converter.command;

import com.beust.jcommander.ParameterException;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.config.data_roots.DataDirsConfig;
import org.terracotta.dynamic_config.cli.api.command.Injector;
import org.terracotta.dynamic_config.cli.api.output.OutputService;
import org.terracotta.dynamic_config.cli.upgrade_tools.config_converter.ConfigConverter;
import org.terracotta.dynamic_config.cli.upgrade_tools.config_converter.ConfigPropertiesProcessor;
import org.terracotta.dynamic_config.cli.upgrade_tools.config_converter.ConfigRepoProcessor;
import org.terracotta.dynamic_config.cli.upgrade_tools.config_converter.ConversionFormat;

public class ConvertAction
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConvertAction.class);
    private List<Path> tcConfigFiles;
    private List<String> stripeNames;
    private Path licensePath;
    private Path destinationDir = Paths.get(".", new String[0]).resolve("converted-configs");
    private String newClusterName;
    private ConversionFormat conversionFormat = ConversionFormat.DIRECTORY;
    private boolean force;
    @Injector.Inject
    public OutputService output;

    public void setTcConfigFiles(List<Path> tcConfigFiles) {
        this.tcConfigFiles = tcConfigFiles;
    }

    public void setStripeNames(List<String> stripeNames) {
        this.stripeNames = stripeNames;
    }

    public void setLicensePath(Path licensePath) {
        this.licensePath = licensePath;
    }

    public void setDestinationDir(Path destinationDir) {
        this.destinationDir = destinationDir;
    }

    public void setNewClusterName(String newClusterName) {
        this.newClusterName = newClusterName;
    }

    public void setConversionFormat(ConversionFormat conversionFormat) {
        this.conversionFormat = conversionFormat;
    }

    public void setForce(boolean force) {
        this.force = force;
    }

    public void validate() {
        if (this.stripeNames == null) {
            this.stripeNames = Collections.emptyList();
        }
        for (Path tcConfigFile : this.tcConfigFiles) {
            if (tcConfigFile.toFile().exists()) continue;
            throw new ParameterException("tc-config file: " + tcConfigFile + " not found");
        }
        if (this.destinationDir.toFile().exists()) {
            throw new ParameterException("Destination directory: " + this.destinationDir.toAbsolutePath().normalize() + " exists already. Please specify a non-existent directory");
        }
        if (this.licensePath != null && this.conversionFormat == ConversionFormat.PROPERTIES) {
            throw new ParameterException("Path to license file can only be provided for conversion into a configuration directory");
        }
        if (this.newClusterName == null && this.conversionFormat == ConversionFormat.DIRECTORY) {
            throw new ParameterException("Cluster name is required for conversion into a configuration directory");
        }
        if (this.licensePath != null && !this.licensePath.toFile().exists()) {
            throw new ParameterException("License file: " + this.licensePath + " not found");
        }
    }

    @Override
    public final void run() {
        this.validate();
        if (this.conversionFormat == ConversionFormat.DIRECTORY) {
            ConfigRepoProcessor resultProcessor = new ConfigRepoProcessor(this.destinationDir);
            ConfigConverter converter = new ConfigConverter(resultProcessor::process, this.force);
            converter.processInput(this.newClusterName, this.stripeNames, this.tcConfigFiles.toArray(new Path[0]));
            if (this.licensePath != null) {
                try (Stream<Path> allLicenseDirs = Files.find(this.destinationDir, 3, (path, attrs) -> path.getFileName().toString().equals("license") && Files.isDirectory(path, new LinkOption[0]), new FileVisitOption[0]);){
                    allLicenseDirs.forEach(licenseDir -> {
                        try {
                            Path destLicenseFile = licenseDir.resolve(this.licensePath.getFileName());
                            org.terracotta.utilities.io.Files.copy((Path)this.licensePath, (Path)destLicenseFile, (CopyOption[])new CopyOption[0]);
                        }
                        catch (IOException e) {
                            throw new UncheckedIOException(e);
                        }
                    });
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            this.output.info("Configuration directories saved under: {}", new Object[]{this.destinationDir.toAbsolutePath().normalize()});
        } else if (this.conversionFormat == ConversionFormat.PROPERTIES) {
            ConfigPropertiesProcessor resultProcessor = new ConfigPropertiesProcessor(this.destinationDir, DataDirsConfig.cleanStringForPath((String)this.newClusterName));
            ConfigConverter converter = new ConfigConverter(resultProcessor::process, this.force);
            converter.processInput(this.newClusterName, this.stripeNames, this.tcConfigFiles.toArray(new Path[0]));
            this.output.info("Configuration properties file saved under: {}", new Object[]{this.destinationDir.toAbsolutePath().normalize()});
        } else {
            throw new AssertionError((Object)("Unexpected conversion format: " + (Object)((Object)this.conversionFormat)));
        }
        this.output.info("Command successful!", new Object[0]);
    }
}

