/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dynamic_config.cli.upgrade_tools.config_converter;

import java.io.IOException;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;
import org.terracotta.dynamic_config.api.model.Cluster;
import org.terracotta.dynamic_config.api.service.Props;

public class ConfigPropertiesProcessor {
    private final Path outputDir;
    private final String fileName;

    public ConfigPropertiesProcessor(Path outputDir, String fileName) {
        this.outputDir = outputDir;
        this.fileName = fileName == null ? "cluster" : fileName;
    }

    public void process(Cluster cluster) {
        Properties properties = cluster.toProperties(false, false, true);
        try (StringWriter out = new StringWriter();){
            Props.store((Writer)out, (Properties)properties, (String)"Converted cluster configuration:");
            Files.createDirectories(this.outputDir, new FileAttribute[0]);
            Files.write(this.outputDir.resolve(this.fileName + ".properties"), out.toString().getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

