/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dynamic_config.cli.upgrade_tools.config_converter;

import com.beust.jcommander.ParameterException;
import java.util.Collections;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.dynamic_config.cli.api.command.Injector;
import org.terracotta.dynamic_config.cli.api.output.ConsoleOutputService;
import org.terracotta.dynamic_config.cli.api.output.OutputService;
import org.terracotta.dynamic_config.cli.command.Command;
import org.terracotta.dynamic_config.cli.command.CustomJCommander;
import org.terracotta.dynamic_config.cli.command.LocalMainCommand;
import org.terracotta.dynamic_config.cli.upgrade_tools.config_converter.parsing.ConvertCommand;
import org.terracotta.dynamic_config.cli.upgrade_tools.config_converter.parsing.deprecated.DeprecatedConvertCommand;

public class ConfigConverterTool {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigConverterTool.class);
    private final OutputService outputService;

    public ConfigConverterTool() {
        this((OutputService)new ConsoleOutputService());
    }

    public ConfigConverterTool(OutputService outputService) {
        this.outputService = outputService;
    }

    public void run(String ... args) {
        LOGGER.debug("Parsing command-line arguments");
        Map<String, Command> commands = Collections.singletonMap("convert", new ConvertCommand());
        Map<String, Command> depCommands = Collections.singletonMap("convert", new DeprecatedConvertCommand());
        CustomJCommander<LocalMainCommand> jCommander = ConfigConverterTool.parseArguments(commands, depCommands, args);
        ((LocalMainCommand)jCommander.getMainCommand()).run();
        jCommander.getAskedCommand().map(command -> {
            if (command.isHelp()) {
                jCommander.printUsage();
                return true;
            }
            Injector.inject((Object)command, Collections.singletonList(this.outputService));
            command.run();
            return true;
        }).orElseGet(() -> {
            jCommander.usage();
            return false;
        });
    }

    public static void main(String ... args) {
        try {
            new ConfigConverterTool().run(args);
        }
        catch (Exception e) {
            String message = e.getMessage();
            if (LOGGER.isDebugEnabled() || message == null || message.isEmpty()) {
                LOGGER.error("Error:", (Throwable)e);
            } else {
                LOGGER.error("Error: {}", (Object)message);
            }
            System.exit(1);
        }
    }

    private static CustomJCommander<LocalMainCommand> parseArguments(Map<String, Command> commands, Map<String, Command> deprecatedCommands, String[] args) {
        LOGGER.debug("Attempting parse using regular commands");
        CustomJCommander<LocalMainCommand> jCommander = ConfigConverterTool.getCustomJCommander(commands, new LocalMainCommand());
        try {
            jCommander.parse(args);
            return jCommander;
        }
        catch (ParameterException e) {
            String command = jCommander.getParsedCommand();
            if (command != null) {
                try {
                    LOGGER.debug("Attempting parse using deprecated commands");
                    CustomJCommander<LocalMainCommand> deprecatedJCommander = ConfigConverterTool.getCustomJCommander(deprecatedCommands, new LocalMainCommand());
                    deprecatedJCommander.parse(args);
                    return deprecatedJCommander;
                }
                catch (ParameterException pe) {
                    jCommander.printAskedCommandUsage(command);
                    throw e;
                }
            }
            jCommander.printUsage();
            throw e;
        }
    }

    private static CustomJCommander<LocalMainCommand> getCustomJCommander(Map<String, Command> commands, LocalMainCommand mainCommand) {
        return new CustomJCommander("config-converter", commands, (Command)mainCommand);
    }
}

