/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dynamic_config.cli.api.nomad;

import java.util.Collection;
import java.util.Map;
import org.terracotta.diagnostic.model.LogicalServerState;
import org.terracotta.dynamic_config.api.model.Cluster;
import org.terracotta.dynamic_config.api.model.Node;
import org.terracotta.dynamic_config.api.model.nomad.DynamicConfigNomadChange;
import org.terracotta.dynamic_config.api.model.nomad.LockAwareDynamicConfigNomadChange;
import org.terracotta.dynamic_config.cli.api.nomad.NomadManager;
import org.terracotta.nomad.client.change.ChangeResultReceiver;
import org.terracotta.nomad.client.recovery.RecoveryResultReceiver;
import org.terracotta.nomad.client.results.DiscoverResultsReceiver;
import org.terracotta.nomad.server.ChangeRequestState;

public class LockAwareNomadManager<T>
implements NomadManager<T> {
    private final String lockToken;
    private final NomadManager<T> underlying;

    public LockAwareNomadManager(String lockToken, NomadManager<T> underlying) {
        this.lockToken = lockToken;
        this.underlying = underlying;
    }

    @Override
    public void runConfigurationDiscovery(Map<Node.Endpoint, LogicalServerState> nodes, DiscoverResultsReceiver<T> results) {
        this.underlying.runConfigurationDiscovery(nodes, results);
    }

    @Override
    public void runClusterActivation(Collection<Node.Endpoint> nodes, Cluster cluster, ChangeResultReceiver<T> results) {
        this.underlying.runClusterActivation(nodes, cluster, results);
    }

    @Override
    public void runConfigurationChange(Cluster destinationCluster, Map<Node.Endpoint, LogicalServerState> onlineNodes, DynamicConfigNomadChange changes, ChangeResultReceiver<T> results) {
        this.underlying.runConfigurationChange(destinationCluster, onlineNodes, (DynamicConfigNomadChange)new LockAwareDynamicConfigNomadChange(this.lockToken, changes), results);
    }

    @Override
    public void runConfigurationRepair(Map<Node.Endpoint, LogicalServerState> onlineActivatedNodes, int totalNodeCount, RecoveryResultReceiver<T> results, ChangeRequestState forcedState) {
        this.underlying.runConfigurationRepair(onlineActivatedNodes, totalNodeCount, results, forcedState);
    }

    public NomadManager<T> getUnderlying() {
        return this.underlying;
    }
}

