/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dynamic_config.cli.api.command;

import java.time.Clock;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Comparator;
import java.util.stream.Stream;
import org.terracotta.dynamic_config.api.service.NomadChangeInfo;
import org.terracotta.dynamic_config.cli.api.command.RemoteAction;
import org.terracotta.inet.HostPort;

public class LogAction
extends RemoteAction {
    private HostPort node;

    public void setNode(HostPort node) {
        this.node = node;
    }

    @Override
    public void run() {
        NomadChangeInfo[] logs = this.getChangeHistory(this.node);
        Arrays.sort(logs, Comparator.comparing(NomadChangeInfo::getVersion));
        Clock clock = Clock.systemDefaultZone();
        ZoneId zoneId = clock.getZone();
        DateTimeFormatter ISO_8601 = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSS");
        Stream.of(logs).map(log -> LogAction.padCut(String.valueOf(log.getVersion()), 4) + " " + log.getCreationTimestamp().atZone(zoneId).toLocalDateTime().format(ISO_8601) + " " + log.getChangeUuid().toString() + " " + log.getChangeResultHash() + " " + log.getChangeRequestState().name() + " | " + log.getCreationUser() + "@" + log.getCreationHost() + " - " + log.getNomadChange().getSummary()).forEach(x$0 -> this.output.out(x$0, new Object[0]));
    }

    private static String padCut(String s, int length) {
        StringBuilder sb = new StringBuilder(s);
        while (sb.length() < length) {
            sb.insert(0, " ");
        }
        return sb.substring(0, length);
    }
}

