/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dynamic_config.cli.api.command;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Stream;

public class Injector {
    public static <T> T inject(T target, Object[] services) {
        return Injector.inject(target, Arrays.asList(services));
    }

    public static <T> T inject(T target, Collection<Object> services) {
        Stream.of(target.getClass().getFields()).filter(field -> field.isAnnotationPresent(Inject.class)).forEach(field -> {
            try {
                Object targetValue = field.get(target);
                if (targetValue == null) {
                    Object found = services.stream().filter(service -> field.getType().isInstance(service)).findAny().orElseThrow(() -> new IllegalStateException("No service found to inject into " + field));
                    field.set(target, found);
                } else {
                    Injector.inject(targetValue, services);
                }
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException(e);
            }
        });
        return target;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Inject {
    }
}

