/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dynamic_config.cli.api.command;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.terracotta.dynamic_config.api.model.Cluster;
import org.terracotta.dynamic_config.api.model.ClusterState;
import org.terracotta.dynamic_config.api.model.Configuration;
import org.terracotta.dynamic_config.api.model.Operation;
import org.terracotta.dynamic_config.api.model.Scope;
import org.terracotta.dynamic_config.api.model.Setting;
import org.terracotta.dynamic_config.cli.api.command.ConfigurationInput;
import org.terracotta.dynamic_config.cli.api.command.RemoteAction;
import org.terracotta.inet.HostPort;

public abstract class ConfigurationAction
extends RemoteAction {
    protected HostPort node;
    protected List<HostPort> nodes = Collections.emptyList();
    protected List<Configuration> configurations;
    protected List<ConfigurationInput> inputs;
    private final EnumSet<Setting> NOT_SUPPORTED_SETTINGS = EnumSet.of(Setting.LOCK_CONTEXT);
    protected final Operation operation;
    protected boolean isActivated;
    protected ClusterState clusterState;

    protected ConfigurationAction(Operation operation) {
        this.operation = operation;
    }

    public void setNodes(List<HostPort> nodes) {
        this.nodes = nodes;
    }

    public void setConfigurationInputs(List<ConfigurationInput> inputs) {
        this.inputs = inputs;
    }

    protected void validate() {
        this.node = this.findAnyOnlineNode(this.nodes).getHostPort();
        Cluster cluster = this.getRuntimeCluster(this.node);
        Map<Scope, List<Configuration>> m = this.inputs.stream().map(input -> input.toConfiguration(cluster)).flatMap(cfg -> cfg.expand().stream()).collect(Collectors.groupingBy(Configuration::getLevel));
        this.configurations = new ArrayList<Configuration>();
        this.configurations.addAll(m.getOrDefault(Scope.CLUSTER, new ArrayList()));
        this.configurations.addAll(m.getOrDefault(Scope.STRIPE, new ArrayList()));
        this.configurations.addAll(m.getOrDefault(Scope.NODE, new ArrayList()));
        this.isActivated = this.isActivated(this.node);
        this.clusterState = this.isActivated ? ClusterState.ACTIVATED : ClusterState.CONFIGURING;
        for (Configuration configuration : this.configurations) {
            if (this.NOT_SUPPORTED_SETTINGS.contains(configuration.getSetting())) {
                throw new IllegalArgumentException(String.format("'%s' is not supported", configuration.getSetting()));
            }
            configuration.validate(this.clusterState, this.operation);
        }
        for (int i = 0; i < this.configurations.size(); ++i) {
            Configuration first = this.configurations.get(i);
            for (int j = i + 1; j < this.configurations.size(); ++j) {
                Configuration second = this.configurations.get(j);
                if (!second.duplicates(first)) continue;
                throw new IllegalArgumentException("Duplicate configurations found: " + first + " and " + second);
            }
        }
    }
}

