/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object.loaders;

public final class LoaderDescription {
    private static final String APP_GROUP_DELIMITER = "%%";
    private final String name;
    private final String appGroup;

    public LoaderDescription(String appGroup, String name) {
        if (name == null || name.length() < 1) {
            throw new IllegalArgumentException("LoaderDescription name must not be empty");
        }
        this.name = name;
        this.appGroup = appGroup != null && appGroup.length() == 0 ? null : appGroup;
    }

    public String name() {
        return this.name;
    }

    public String appGroup() {
        return this.appGroup;
    }

    public String toString() {
        return (this.appGroup == null ? "" : this.appGroup) + APP_GROUP_DELIMITER + this.name;
    }

    public String toDelimitedString() {
        return this.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.appGroup == null ? 0 : this.appGroup.hashCode());
        result = 31 * result + this.name.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LoaderDescription other = (LoaderDescription)obj;
        if (this.appGroup == null ? other.appGroup != null : !this.appGroup.equals(other.appGroup)) {
            return false;
        }
        return this.name.equals(other.name);
    }

    public static LoaderDescription fromString(String desc) {
        int delim = desc.indexOf(APP_GROUP_DELIMITER);
        if (delim < 0) {
            return new LoaderDescription(null, desc);
        }
        String appGroup = null;
        if (delim > 0) {
            appGroup = desc.substring(0, delim);
        }
        String name = desc.substring(delim + 2);
        return new LoaderDescription(appGroup, name);
    }
}

