/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object.bytecode;

import com.tc.asm.ClassVisitor;
import com.tc.asm.FieldVisitor;
import com.tc.asm.MethodVisitor;
import com.tc.asm.Opcodes;
import com.tc.asm.commons.AdviceAdapter;
import com.tc.asm.tree.ClassNode;
import com.tc.asm.tree.FieldNode;
import com.tc.asm.tree.InnerClassNode;
import com.tc.asm.tree.MethodNode;
import com.tc.object.bytecode.ChangeClassNameHierarchyAdapter;
import com.tc.object.bytecode.LogicalClassSerializationAdapter;
import com.tc.object.bytecode.TransparencyClassAdapterHack;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MergeTCToJavaClassAdapter
extends ChangeClassNameHierarchyAdapter
implements Opcodes {
    private static final String TC_INIT = "__tc_$$_init_$$";
    private final List<String> jInnerClassNames = new ArrayList<String>();
    private final ClassNode tcClassNode;
    private final String jFullClassSlashes;
    private final String tcFullClassSlashes;
    private final Map instrumentedContext;
    private final Set visitedMethods;
    private final String methodPrefix;
    private final boolean insertTCinit;
    private String superName;
    private final ClassVisitor dsoAdapter;

    public MergeTCToJavaClassAdapter(ClassVisitor cv, ClassVisitor dsoAdapter, String jFullClassDots, String tcFullClassDots, ClassNode tcClassNode, Map instrumentedContext, String methodPrefix, boolean insertTCinit) {
        super(cv);
        this.insertTCinit = insertTCinit;
        if (insertTCinit) {
            MergeTCToJavaClassAdapter.createTCInit(tcClassNode);
        }
        this.tcClassNode = tcClassNode;
        this.jFullClassSlashes = jFullClassDots.replace('.', '/');
        this.tcFullClassSlashes = tcFullClassDots.replace('.', '/');
        this.addNewContextIfNotExist(tcFullClassDots, jFullClassDots, instrumentedContext);
        this.instrumentedContext = instrumentedContext;
        this.visitedMethods = new HashSet();
        this.dsoAdapter = dsoAdapter;
        this.methodPrefix = methodPrefix;
    }

    private static void createTCInit(ClassNode tcClassNode) {
        ArrayList<MethodNode> cstrs = new ArrayList<MethodNode>();
        for (MethodNode mn : tcClassNode.methods) {
            if (!MergeTCToJavaClassAdapter.isInitMethod(mn.name)) continue;
            cstrs.add(mn);
        }
        if (cstrs.size() > 1) {
            throw new IllegalArgumentException(tcClassNode.name + " contains " + cstrs.size() + " constructors, but only 1 is allowed");
        }
        MethodNode cstr = (MethodNode)cstrs.get(0);
        if (!cstr.exceptions.isEmpty()) {
            throw new IllegalArgumentException("constructor in TC class not allowed to throw checked exceptions: " + cstr.exceptions);
        }
        MethodNode processed = new MethodNode();
        cstr.accept(new TransformConstructorAdapter(processed, cstr.access, cstr.name, cstr.desc));
        cstr.instructions = processed.instructions;
        cstr.access = 4098;
        cstr.name = TC_INIT;
    }

    public MergeTCToJavaClassAdapter(ClassVisitor cv, ClassVisitor dsoAdapter, String jFullClassDots, String tcFullClassDots, ClassNode tcClassNode, Map instrumentedContext) {
        this(cv, dsoAdapter, jFullClassDots, tcFullClassDots, tcClassNode, instrumentedContext, "__tc_", true);
    }

    public void visit(int version, int access, String name, String signature, String superClassName, String[] interfaces) {
        this.superName = superClassName;
        List<String> tcInterfaces = this.tcClassNode.interfaces;
        ArrayList<String> jInterfaces = new ArrayList<String>();
        for (int i = 0; i < interfaces.length; ++i) {
            if (tcInterfaces.contains(interfaces[i])) continue;
            jInterfaces.add(interfaces[i]);
        }
        for (String intf : tcInterfaces) {
            jInterfaces.add(intf);
        }
        interfaces = new String[jInterfaces.size()];
        jInterfaces.toArray(interfaces);
        if (this.dsoAdapter == null) {
            super.visit(version, access, name, signature, this.superName, interfaces);
        } else {
            this.dsoAdapter.visit(version, access, name, signature, superClassName, interfaces);
        }
    }

    private String getNewName(String methodName) {
        if (MergeTCToJavaClassAdapter.isInitMethod(methodName)) {
            return methodName;
        }
        return this.methodPrefix + methodName;
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        String methodDesc = name + desc;
        this.visitedMethods.add(methodDesc);
        if (!MergeTCToJavaClassAdapter.isInitMethod(name)) {
            for (MethodNode replacement : this.tcClassNode.methods) {
                if (0 != (replacement.access & 0x400) || !replacement.name.equals(name) || !replacement.desc.equals(desc)) continue;
                String remappedName = this.getNewName(name);
                boolean remappedIsDefined = false;
                for (MethodNode remapped : this.tcClassNode.methods) {
                    if (0 != (remapped.access & 0x400) || !remapped.name.equals(remappedName) || !remapped.desc.equals(desc)) continue;
                    remappedIsDefined = true;
                    break;
                }
                if (remappedIsDefined) {
                    return null;
                }
                replacement.signature = signature;
                return super.visitMethod(2, remappedName, desc, signature, exceptions);
            }
        }
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        if ("writeObject(Ljava/io/ObjectOutputStream;)V".equals(methodDesc) || "readObject(Ljava/io/ObjectInputStream;)V".equals(methodDesc)) {
            return new LogicalClassSerializationAdapter.LogicalClassSerializationMethodAdapter(mv, this.jFullClassSlashes);
        }
        if (this.insertTCinit && MergeTCToJavaClassAdapter.isInitMethod(name)) {
            mv = new AddTCInitCallAdapter(this.jFullClassSlashes, mv, access, name, desc);
        }
        return mv;
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        List<FieldNode> tcFields = this.tcClassNode.fields;
        Iterator<FieldNode> i = tcFields.iterator();
        while (i.hasNext()) {
            FieldNode fieldNode = i.next();
            if (!name.equals(fieldNode.name) || !desc.equals(fieldNode.desc)) continue;
            i.remove();
            break;
        }
        if ("java/util/LinkedHashMap".equals(this.jFullClassSlashes) && "accessOrder".equals(name) || "java/util/concurrent/locks/ReentrantReadWriteLock".equals(this.jFullClassSlashes) && ("sync".equals(name) || "readerLock".equals(name) || "writerLock".equals(name))) {
            access = 0xFFFFFFEF & access;
        }
        return super.visitField(access, name, desc, signature, value);
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        this.jInnerClassNames.add(name);
        super.visitInnerClass(name, outerName, innerName, access);
    }

    public void visitEnd() {
        this.addTCFields();
        this.addTCMethods();
        this.addTCInnerClasses();
        super.visitEnd();
    }

    private void addTCMethods() {
        List<MethodNode> tcMethods = this.tcClassNode.methods;
        for (MethodNode mNode : tcMethods) {
            if ((mNode.access & 0x400) != 0 || MergeTCToJavaClassAdapter.isInitMethod(mNode.name) && this.visitedMethods.contains(mNode.name + mNode.desc)) continue;
            mNode.accept(new TCSuperClassAdapter(this.cv));
        }
        LogicalClassSerializationAdapter.addCheckSerializationOverrideMethod(this.cv, false);
    }

    private static boolean isInitMethod(String methodName) {
        return "<init>".equals(methodName);
    }

    private void addTCFields() {
        List<FieldNode> tcFields = this.tcClassNode.fields;
        for (FieldNode fNode : tcFields) {
            fNode.accept(this.cv);
        }
    }

    private void addTCInnerClasses() {
        List<InnerClassNode> tcInnerClasses = this.tcClassNode.innerClasses;
        for (InnerClassNode innerClass : tcInnerClasses) {
            if (this.tcInnerClassExistInJavaClass(innerClass)) continue;
            innerClass.accept(new TCSuperClassAdapter(this.cv));
        }
    }

    private boolean tcInnerClassExistInJavaClass(InnerClassNode tcInnerClass) {
        return this.jInnerClassNames.contains(this.replaceClassName(tcInnerClass.name));
    }

    private String replaceClassName(String classNameDots) {
        return this.replaceClassName(classNameDots, this.tcFullClassSlashes, this.jFullClassSlashes);
    }

    private String replaceClassName(String classNameDots, String srcClassNameDots, String targetClassNameDots) {
        if (classNameDots == null || classNameDots.length() == 0) {
            return classNameDots;
        }
        classNameDots = classNameDots.replace('.', '/');
        srcClassNameDots = srcClassNameDots.replace('.', '/');
        targetClassNameDots = targetClassNameDots.replace('.', '/');
        int index = classNameDots.indexOf(srcClassNameDots);
        if (index == -1) {
            return classNameDots;
        }
        StringBuffer newClassName = new StringBuffer();
        while (index != -1) {
            if (index > 0) {
                newClassName.append(classNameDots.substring(0, index));
            }
            newClassName.append(targetClassNameDots);
            classNameDots = classNameDots.substring(index + srcClassNameDots.length());
            index = classNameDots.indexOf(srcClassNameDots);
        }
        newClassName.append(classNameDots);
        return newClassName.toString();
    }

    private static class AddTCInitCallAdapter
    extends AdviceAdapter
    implements Opcodes {
        private final String owner;

        public AddTCInitCallAdapter(String owner, MethodVisitor mv, int access, String name, String desc) {
            super(327680, mv, access, name, desc);
            this.owner = owner;
        }

        protected void onMethodEnter() {
        }

        protected void onMethodExit(int opcode) {
            if (177 == opcode) {
                super.visitVarInsn(25, 0);
                super.visitMethodInsn(183, this.owner, MergeTCToJavaClassAdapter.TC_INIT, "()V");
            }
        }
    }

    private static class TransformConstructorAdapter
    extends AdviceAdapter {
        private final MethodNode target;

        public TransformConstructorAdapter(MethodNode mv, int access, String name, String desc) {
            super(327680, mv, access, name, desc);
            this.target = mv;
        }

        protected void onMethodEnter() {
            this.target.instructions.clear();
        }

        protected void onMethodExit(int opcode) {
        }
    }

    private class TCSuperClassAdapter
    extends ClassVisitor
    implements Opcodes {
        public TCSuperClassAdapter(ClassVisitor cv) {
            super(327680, cv);
        }

        public void visit(int version, int access, String name, String signature, String superClassName, String[] interfaces) {
            name = MergeTCToJavaClassAdapter.this.replaceClassName(name);
            superClassName = MergeTCToJavaClassAdapter.this.replaceClassName(superClassName);
            super.visit(version, access & 0xFFFFFBFF, name, signature, superClassName, interfaces);
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            desc = MergeTCToJavaClassAdapter.this.replaceClassName(desc);
            signature = MergeTCToJavaClassAdapter.this.replaceClassName(signature);
            if (MergeTCToJavaClassAdapter.this.dsoAdapter == null) {
                return new TCSuperMethodAdapter(super.visitMethod(access, name, desc, signature, exceptions));
            }
            return new TCSuperMethodAdapter(((TransparencyClassAdapterHack)((Object)MergeTCToJavaClassAdapter.this.dsoAdapter)).basicVisitMethodHack(access, name, desc, signature, exceptions));
        }

        public void visitInnerClass(String name, String outerName, String innerName, int access) {
            super.visitInnerClass(MergeTCToJavaClassAdapter.this.replaceClassName(name), MergeTCToJavaClassAdapter.this.replaceClassName(outerName), MergeTCToJavaClassAdapter.this.replaceClassName(innerName), access);
        }

        private class TCSuperMethodAdapter
        extends MethodVisitor
        implements Opcodes {
            public TCSuperMethodAdapter(MethodVisitor mv) {
                super(327680, mv);
            }

            public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
                int index = owner.indexOf(MergeTCToJavaClassAdapter.this.tcFullClassSlashes);
                if (opcode == 183 && index == -1) {
                    if (!MergeTCToJavaClassAdapter.this.visitedMethods.contains(name + desc) && !MergeTCToJavaClassAdapter.isInitMethod(name)) {
                        owner = MergeTCToJavaClassAdapter.this.superName;
                    } else {
                        ChangeClassNameHierarchyAdapter.ChangeContext context = (ChangeClassNameHierarchyAdapter.ChangeContext)MergeTCToJavaClassAdapter.this.instrumentedContext.get(owner);
                        if (context != null) {
                            owner = context.convertedClassNameSlashes;
                        }
                        name = MergeTCToJavaClassAdapter.this.getNewName(name);
                    }
                    super.visitMethodInsn(opcode, owner, name, desc, itf);
                } else {
                    owner = MergeTCToJavaClassAdapter.this.replaceClassName(owner);
                    desc = MergeTCToJavaClassAdapter.this.replaceClassName(desc);
                    super.visitMethodInsn(opcode, owner, name, desc, itf);
                }
            }

            public void visitFieldInsn(int opcode, String owner, String name, String desc) {
                owner = MergeTCToJavaClassAdapter.this.replaceClassName(owner);
                desc = MergeTCToJavaClassAdapter.this.replaceClassName(desc);
                super.visitFieldInsn(opcode, owner, name, desc);
            }

            public void visitTypeInsn(int opcode, String desc) {
                ChangeClassNameHierarchyAdapter.ChangeContext context = (ChangeClassNameHierarchyAdapter.ChangeContext)MergeTCToJavaClassAdapter.this.instrumentedContext.get(desc);
                desc = context != null ? context.convertedClassNameSlashes : MergeTCToJavaClassAdapter.this.replaceClassName(desc);
                super.visitTypeInsn(opcode, desc);
            }
        }
    }
}

