/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object;

import com.tc.object.ObjectID;
import com.tc.object.loaders.NamedClassLoader;
import com.tc.util.Assert;
import com.tc.util.ClassUtils;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Collections;
import java.util.Currency;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum LiteralValues {
    INTEGER{

        public String getTypeDesc() {
            return "I";
        }

        public String getClassNameSlashForPrimitives() {
            return "java/lang/Integer";
        }

        public String getMethodNameForPrimitives() {
            return "intValue";
        }

        public String getInputMethodDescriptor() {
            return "()I";
        }

        public String getInputMethodName() {
            return "readInt";
        }

        public String getOutputMethodDescriptor() {
            return "(I)V";
        }

        public String getOutputMethodName() {
            return "writeInt";
        }
    }
    ,
    LONG{

        public String getTypeDesc() {
            return "J";
        }

        public String getClassNameSlashForPrimitives() {
            return "java/lang/Long";
        }

        public String getMethodNameForPrimitives() {
            return "longValue";
        }

        public String getInputMethodDescriptor() {
            return "()J";
        }

        public String getInputMethodName() {
            return "readLong";
        }

        public String getOutputMethodDescriptor() {
            return "(J)V";
        }

        public String getOutputMethodName() {
            return "writeLong";
        }
    }
    ,
    CHARACTER{

        public String getTypeDesc() {
            return "C";
        }

        public String getClassNameSlashForPrimitives() {
            return "java/lang/Character";
        }

        public String getMethodNameForPrimitives() {
            return "charValue";
        }

        public String getInputMethodDescriptor() {
            return "()C";
        }

        public String getInputMethodName() {
            return "readChar";
        }

        public String getOutputMethodDescriptor() {
            return "(I)V";
        }

        public String getOutputMethodName() {
            return "writeChar";
        }
    }
    ,
    FLOAT{

        public String getTypeDesc() {
            return "F";
        }

        public String getClassNameSlashForPrimitives() {
            return "java/lang/Float";
        }

        public String getMethodNameForPrimitives() {
            return "floatValue";
        }

        public String getInputMethodDescriptor() {
            return "()F";
        }

        public String getInputMethodName() {
            return "readFloat";
        }

        public String getOutputMethodDescriptor() {
            return "(F)V";
        }

        public String getOutputMethodName() {
            return "writeFloat";
        }
    }
    ,
    DOUBLE{

        public String getTypeDesc() {
            return "D";
        }

        public String getClassNameSlashForPrimitives() {
            return "java/lang/Double";
        }

        public String getMethodNameForPrimitives() {
            return "doubleValue";
        }

        public String getInputMethodDescriptor() {
            return "()D";
        }

        public String getInputMethodName() {
            return "readDouble";
        }

        public String getOutputMethodDescriptor() {
            return "(D)V";
        }

        public String getOutputMethodName() {
            return "writeDouble";
        }
    }
    ,
    BYTE{

        public String getTypeDesc() {
            return "B";
        }

        public String getClassNameSlashForPrimitives() {
            return "java/lang/Byte";
        }

        public String getMethodNameForPrimitives() {
            return "byteValue";
        }

        public String getInputMethodDescriptor() {
            return "()B";
        }

        public String getInputMethodName() {
            return "readByte";
        }

        public String getOutputMethodDescriptor() {
            return "(I)V";
        }

        public String getOutputMethodName() {
            return "writeByte";
        }
    }
    ,
    BOOLEAN{

        public String getTypeDesc() {
            return "Z";
        }

        public String getClassNameSlashForPrimitives() {
            return "java/lang/Boolean";
        }

        public String getMethodNameForPrimitives() {
            return "booleanValue";
        }

        public String getInputMethodDescriptor() {
            return "()Z";
        }

        public String getInputMethodName() {
            return "readBoolean";
        }

        public String getOutputMethodDescriptor() {
            return "(Z)V";
        }

        public String getOutputMethodName() {
            return "writeBoolean";
        }
    }
    ,
    SHORT{

        public String getTypeDesc() {
            return "S";
        }

        public String getClassNameSlashForPrimitives() {
            return "java/lang/Short";
        }

        public String getMethodNameForPrimitives() {
            return "shortValue";
        }

        public String getInputMethodDescriptor() {
            return "()S";
        }

        public String getInputMethodName() {
            return "readShort";
        }

        public String getOutputMethodDescriptor() {
            return "(I)V";
        }

        public String getOutputMethodName() {
            return "writeShort";
        }
    }
    ,
    STRING,
    ARRAY{

        public int calculateDsoHashCodeForLiteral(Object value) {
            throw new UnsupportedOperationException("Cannot calculate hashCode for " + this.name());
        }
    }
    ,
    OBJECT{

        public int calculateDsoHashCodeForLiteral(Object value) {
            throw new UnsupportedOperationException("Cannot calculate hashCode for " + this.name());
        }
    }
    ,
    OBJECT_ID,
    STRING_BYTES,
    JAVA_LANG_CLASS{

        public int calculateDsoHashCodeForLiteral(Object value) {
            return ((Class)value).getCanonicalName().hashCode();
        }
    }
    ,
    JAVA_LANG_CLASS_HOLDER,
    STACK_TRACE_ELEMENT,
    BIG_INTEGER,
    BIG_DECIMAL,
    JAVA_LANG_CLASSLOADER{

        public int calculateDsoHashCodeForLiteral(Object value) {
            return ((NamedClassLoader)value).__tc_getClassLoaderName().hashCode();
        }
    }
    ,
    JAVA_LANG_CLASSLOADER_HOLDER,
    ENUM{

        public int calculateDsoHashCodeForLiteral(Object value) {
            Enum e = (Enum)value;
            int hash = 17;
            hash = 31 * hash + e.name().hashCode();
            hash = 31 * hash + e.getDeclaringClass().getCanonicalName().hashCode();
            return hash;
        }
    }
    ,
    ENUM_HOLDER,
    CURRENCY{

        public int calculateDsoHashCodeForLiteral(Object value) {
            return ((Currency)value).getCurrencyCode().hashCode();
        }
    }
    ,
    STRING_BYTES_COMPRESSED;

    public static final String ENUM_CLASS_DOTS = "java.lang.Enum";
    private static final Map<String, LiteralValues> literalsMap;

    public String getInputMethodName() {
        return "readObject";
    }

    public String getInputMethodDescriptor() {
        return "()Ljava/lang/Object;";
    }

    public String getOutputMethodName() {
        return "writeObject";
    }

    public String getOutputMethodDescriptor() {
        return "(Ljava/lang/Object;)V";
    }

    public String getTypeDesc() {
        return "Ljava/lang/Object;";
    }

    public String getClassNameSlashForPrimitives() {
        return "java/lang/Object";
    }

    public String getMethodNameForPrimitives() {
        throw new AssertionError((Object)("Only Primitive types allowed. Invalid type: " + this.toString()));
    }

    public int calculateDsoHashCodeForLiteral(Object value) {
        if (!LiteralValues.isLiteralInstance(value)) {
            throw new UnsupportedOperationException("Cannot calculate hashCode for non-literals");
        }
        return value.hashCode();
    }

    private static void addMapping(Map<String, LiteralValues> map, String className, LiteralValues type) {
        LiteralValues prev = map.put(className, type);
        Assert.assertNull(className, (Object)prev);
    }

    public static LiteralValues valueFor(Object pojo) {
        if (pojo instanceof ClassLoader) {
            return JAVA_LANG_CLASSLOADER;
        }
        Class<?> clazz = pojo.getClass();
        LiteralValues i = LiteralValues.valueForClassName(clazz.getName());
        if (i == OBJECT && ClassUtils.isDsoEnum(pojo.getClass())) {
            return ENUM;
        }
        return i;
    }

    public static LiteralValues valueForClassName(String className) {
        if (className != null && className.startsWith("[")) {
            return ARRAY;
        }
        LiteralValues literalValueType = literalsMap.get(className);
        if (literalValueType == null) {
            return OBJECT;
        }
        return literalValueType;
    }

    public static boolean isLiteral(String className) {
        LiteralValues i = LiteralValues.valueForClassName(className);
        return i != OBJECT && i != ARRAY;
    }

    public static boolean isLiteralInstance(Object obj) {
        if (obj == null) {
            return false;
        }
        LiteralValues i = LiteralValues.valueFor(obj);
        return i != OBJECT && i != ARRAY;
    }

    public static Collection<String> getTypes() {
        return Collections.unmodifiableSet(literalsMap.keySet());
    }

    public static int calculateDsoHashCode(Object value) {
        LiteralValues type = LiteralValues.valueFor(value);
        return type.calculateDsoHashCodeForLiteral(value);
    }

    static {
        HashMap<String, LiteralValues> tmp = new HashMap<String, LiteralValues>();
        LiteralValues.addMapping(tmp, Integer.class.getName(), INTEGER);
        LiteralValues.addMapping(tmp, Integer.TYPE.getName(), INTEGER);
        LiteralValues.addMapping(tmp, Long.class.getName(), LONG);
        LiteralValues.addMapping(tmp, Long.TYPE.getName(), LONG);
        LiteralValues.addMapping(tmp, Character.class.getName(), CHARACTER);
        LiteralValues.addMapping(tmp, Character.TYPE.getName(), CHARACTER);
        LiteralValues.addMapping(tmp, Float.class.getName(), FLOAT);
        LiteralValues.addMapping(tmp, Float.TYPE.getName(), FLOAT);
        LiteralValues.addMapping(tmp, Double.class.getName(), DOUBLE);
        LiteralValues.addMapping(tmp, Double.TYPE.getName(), DOUBLE);
        LiteralValues.addMapping(tmp, Byte.class.getName(), BYTE);
        LiteralValues.addMapping(tmp, Byte.TYPE.getName(), BYTE);
        LiteralValues.addMapping(tmp, String.class.getName(), STRING);
        LiteralValues.addMapping(tmp, "com.tc.object.dna.impl.UTF8ByteDataHolder", STRING_BYTES);
        LiteralValues.addMapping(tmp, "com.tc.object.dna.impl.UTF8ByteCompressedDataHolder", STRING_BYTES_COMPRESSED);
        LiteralValues.addMapping(tmp, Short.class.getName(), SHORT);
        LiteralValues.addMapping(tmp, Short.TYPE.getName(), SHORT);
        LiteralValues.addMapping(tmp, Boolean.class.getName(), BOOLEAN);
        LiteralValues.addMapping(tmp, Boolean.TYPE.getName(), BOOLEAN);
        LiteralValues.addMapping(tmp, BigInteger.class.getName(), BIG_INTEGER);
        LiteralValues.addMapping(tmp, BigDecimal.class.getName(), BIG_DECIMAL);
        LiteralValues.addMapping(tmp, Class.class.getName(), JAVA_LANG_CLASS);
        LiteralValues.addMapping(tmp, "com.tc.object.dna.impl.ClassInstance", JAVA_LANG_CLASS_HOLDER);
        LiteralValues.addMapping(tmp, ObjectID.class.getName(), OBJECT_ID);
        LiteralValues.addMapping(tmp, StackTraceElement.class.getName(), STACK_TRACE_ELEMENT);
        LiteralValues.addMapping(tmp, "com.tc.object.dna.impl.ClassLoaderInstance", JAVA_LANG_CLASSLOADER_HOLDER);
        LiteralValues.addMapping(tmp, ENUM_CLASS_DOTS, ENUM);
        LiteralValues.addMapping(tmp, "com.tc.object.dna.impl.EnumInstance", ENUM_HOLDER);
        LiteralValues.addMapping(tmp, Currency.class.getName(), CURRENCY);
        literalsMap = Collections.unmodifiableMap(tmp);
    }
}

