/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.lite.schema;

import com.google.flatbuffers.BaseVector;
import com.google.flatbuffers.Constants;
import com.google.flatbuffers.FlatBufferBuilder;
import com.google.flatbuffers.Table;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.tensorflow.lite.schema.DepthwiseConv2DOptionsT;

public final class DepthwiseConv2DOptions
extends Table {
    public static void ValidateVersion() {
        Constants.FLATBUFFERS_23_5_26();
    }

    public static DepthwiseConv2DOptions getRootAsDepthwiseConv2DOptions(ByteBuffer _bb) {
        return DepthwiseConv2DOptions.getRootAsDepthwiseConv2DOptions(_bb, new DepthwiseConv2DOptions());
    }

    public static DepthwiseConv2DOptions getRootAsDepthwiseConv2DOptions(ByteBuffer _bb, DepthwiseConv2DOptions obj) {
        _bb.order(ByteOrder.LITTLE_ENDIAN);
        return obj.__assign(_bb.getInt(_bb.position()) + _bb.position(), _bb);
    }

    public void __init(int _i, ByteBuffer _bb) {
        this.__reset(_i, _bb);
    }

    public DepthwiseConv2DOptions __assign(int _i, ByteBuffer _bb) {
        this.__init(_i, _bb);
        return this;
    }

    public byte padding() {
        int o = this.__offset(4);
        return o != 0 ? this.bb.get(o + this.bb_pos) : (byte)0;
    }

    public int strideW() {
        int o = this.__offset(6);
        return o != 0 ? this.bb.getInt(o + this.bb_pos) : 0;
    }

    public int strideH() {
        int o = this.__offset(8);
        return o != 0 ? this.bb.getInt(o + this.bb_pos) : 0;
    }

    public int depthMultiplier() {
        int o = this.__offset(10);
        return o != 0 ? this.bb.getInt(o + this.bb_pos) : 0;
    }

    public byte fusedActivationFunction() {
        int o = this.__offset(12);
        return o != 0 ? this.bb.get(o + this.bb_pos) : (byte)0;
    }

    public int dilationWFactor() {
        int o = this.__offset(14);
        return o != 0 ? this.bb.getInt(o + this.bb_pos) : 1;
    }

    public int dilationHFactor() {
        int o = this.__offset(16);
        return o != 0 ? this.bb.getInt(o + this.bb_pos) : 1;
    }

    public static int createDepthwiseConv2DOptions(FlatBufferBuilder builder, byte padding, int strideW, int strideH, int depthMultiplier, byte fusedActivationFunction, int dilationWFactor, int dilationHFactor) {
        builder.startTable(7);
        DepthwiseConv2DOptions.addDilationHFactor(builder, dilationHFactor);
        DepthwiseConv2DOptions.addDilationWFactor(builder, dilationWFactor);
        DepthwiseConv2DOptions.addDepthMultiplier(builder, depthMultiplier);
        DepthwiseConv2DOptions.addStrideH(builder, strideH);
        DepthwiseConv2DOptions.addStrideW(builder, strideW);
        DepthwiseConv2DOptions.addFusedActivationFunction(builder, fusedActivationFunction);
        DepthwiseConv2DOptions.addPadding(builder, padding);
        return DepthwiseConv2DOptions.endDepthwiseConv2DOptions(builder);
    }

    public static void startDepthwiseConv2DOptions(FlatBufferBuilder builder) {
        builder.startTable(7);
    }

    public static void addPadding(FlatBufferBuilder builder, byte padding) {
        builder.addByte(0, padding, 0);
    }

    public static void addStrideW(FlatBufferBuilder builder, int strideW) {
        builder.addInt(1, strideW, 0);
    }

    public static void addStrideH(FlatBufferBuilder builder, int strideH) {
        builder.addInt(2, strideH, 0);
    }

    public static void addDepthMultiplier(FlatBufferBuilder builder, int depthMultiplier) {
        builder.addInt(3, depthMultiplier, 0);
    }

    public static void addFusedActivationFunction(FlatBufferBuilder builder, byte fusedActivationFunction) {
        builder.addByte(4, fusedActivationFunction, 0);
    }

    public static void addDilationWFactor(FlatBufferBuilder builder, int dilationWFactor) {
        builder.addInt(5, dilationWFactor, 1);
    }

    public static void addDilationHFactor(FlatBufferBuilder builder, int dilationHFactor) {
        builder.addInt(6, dilationHFactor, 1);
    }

    public static int endDepthwiseConv2DOptions(FlatBufferBuilder builder) {
        int o = builder.endTable();
        return o;
    }

    public DepthwiseConv2DOptionsT unpack() {
        DepthwiseConv2DOptionsT _o = new DepthwiseConv2DOptionsT();
        this.unpackTo(_o);
        return _o;
    }

    public void unpackTo(DepthwiseConv2DOptionsT _o) {
        byte _oPadding = this.padding();
        _o.setPadding(_oPadding);
        int _oStrideW = this.strideW();
        _o.setStrideW(_oStrideW);
        int _oStrideH = this.strideH();
        _o.setStrideH(_oStrideH);
        int _oDepthMultiplier = this.depthMultiplier();
        _o.setDepthMultiplier(_oDepthMultiplier);
        byte _oFusedActivationFunction = this.fusedActivationFunction();
        _o.setFusedActivationFunction(_oFusedActivationFunction);
        int _oDilationWFactor = this.dilationWFactor();
        _o.setDilationWFactor(_oDilationWFactor);
        int _oDilationHFactor = this.dilationHFactor();
        _o.setDilationHFactor(_oDilationHFactor);
    }

    public static int pack(FlatBufferBuilder builder, DepthwiseConv2DOptionsT _o) {
        if (_o == null) {
            return 0;
        }
        return DepthwiseConv2DOptions.createDepthwiseConv2DOptions(builder, _o.getPadding(), _o.getStrideW(), _o.getStrideH(), _o.getDepthMultiplier(), _o.getFusedActivationFunction(), _o.getDilationWFactor(), _o.getDilationHFactor());
    }

    public static final class Vector
    extends BaseVector {
        public Vector __assign(int _vector, int _element_size, ByteBuffer _bb) {
            this.__reset(_vector, _element_size, _bb);
            return this;
        }

        public DepthwiseConv2DOptions get(int j) {
            return this.get(new DepthwiseConv2DOptions(), j);
        }

        public DepthwiseConv2DOptions get(DepthwiseConv2DOptions obj, int j) {
            return obj.__assign(DepthwiseConv2DOptions.__indirect((int)this.__element(j), (ByteBuffer)this.bb), this.bb);
        }
    }
}

