/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.lite.gpu;

import java.io.Closeable;
import org.tensorflow.lite.gpu.GpuDelegate;
import org.tensorflow.lite.gpu.GpuDelegateNative;

public class CompatibilityList
implements Closeable {
    private static final long INVALID_COMPATIBILITY_LIST_HANDLE = 0L;
    private long compatibilityListHandle = 0L;

    public boolean isDelegateSupportedOnThisDevice() {
        if (this.compatibilityListHandle == 0L) {
            throw new IllegalStateException("Trying to query a closed compatibilityList.");
        }
        return CompatibilityList.nativeIsDelegateSupportedOnThisDevice(this.compatibilityListHandle);
    }

    public GpuDelegate.Options getBestOptionsForThisDevice() {
        return new GpuDelegate.Options();
    }

    public CompatibilityList() {
        GpuDelegateNative.init();
        this.compatibilityListHandle = CompatibilityList.createCompatibilityList();
    }

    @Override
    public void close() {
        if (this.compatibilityListHandle != 0L) {
            CompatibilityList.deleteCompatibilityList(this.compatibilityListHandle);
            this.compatibilityListHandle = 0L;
        }
    }

    private static native long createCompatibilityList();

    private static native void deleteCompatibilityList(long var0);

    private static native boolean nativeIsDelegateSupportedOnThisDevice(long var0);
}

