/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.lite.gpu;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.tensorflow.lite.Delegate;
import org.tensorflow.lite.DelegateFactory;
import org.tensorflow.lite.RuntimeFlavor;

public class GpuDelegateFactory
implements DelegateFactory {
    private static final String GPU_DELEGATE_CLASS_NAME = "GpuDelegate";
    private final Options options;

    public GpuDelegateFactory() {
        this(new Options());
    }

    public GpuDelegateFactory(Options options) {
        this.options = options;
    }

    public Delegate create(RuntimeFlavor runtimeFlavor) {
        String packageName;
        switch (runtimeFlavor) {
            case APPLICATION: {
                packageName = "org.tensorflow.lite.gpu";
                break;
            }
            case SYSTEM: {
                packageName = "com.google.android.gms.tflite.gpu";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported runtime flavor " + runtimeFlavor);
            }
        }
        try {
            Class<?> delegateClass = Class.forName(packageName + "." + GPU_DELEGATE_CLASS_NAME);
            Constructor<?> constructor = delegateClass.getDeclaredConstructor(Options.class);
            return (Delegate)constructor.newInstance(this.options);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException("Error creating GPU delegate", e);
        }
    }

    public static class Options {
        public static final int INFERENCE_PREFERENCE_FAST_SINGLE_ANSWER = 0;
        public static final int INFERENCE_PREFERENCE_SUSTAINED_SPEED = 1;
        private boolean precisionLossAllowed = true;
        boolean quantizedModelsAllowed = true;
        int inferencePreference = 0;
        String serializationDir = null;
        String modelToken = null;
        GpuBackend forceBackend = GpuBackend.UNSET;

        public Options setPrecisionLossAllowed(boolean precisionLossAllowed) {
            this.precisionLossAllowed = precisionLossAllowed;
            return this;
        }

        public Options setQuantizedModelsAllowed(boolean quantizedModelsAllowed) {
            this.quantizedModelsAllowed = quantizedModelsAllowed;
            return this;
        }

        public Options setInferencePreference(int preference) {
            this.inferencePreference = preference;
            return this;
        }

        public Options setSerializationParams(String serializationDir, String modelToken) {
            this.serializationDir = serializationDir;
            this.modelToken = modelToken;
            return this;
        }

        public Options setForceBackend(GpuBackend forceBackend) {
            this.forceBackend = forceBackend;
            return this;
        }

        public boolean isPrecisionLossAllowed() {
            return this.precisionLossAllowed;
        }

        public boolean areQuantizedModelsAllowed() {
            return this.quantizedModelsAllowed;
        }

        public int getInferencePreference() {
            return this.inferencePreference;
        }

        public String getSerializationDir() {
            return this.serializationDir;
        }

        public String getModelToken() {
            return this.modelToken;
        }

        public GpuBackend getForceBackend() {
            return this.forceBackend;
        }

        public static enum GpuBackend {
            UNSET(0),
            OPENCL(1),
            OPENGL(2);

            private final int value;

            private GpuBackend(int value) {
                this.value = value;
            }

            public int value() {
                return this.value;
            }
        }
    }
}

