/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.nn;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class ComputeAccidentalHits
extends PrimitiveOp {
    private Output<Integer> indices;
    private Output<Long> ids;
    private Output<Float> weights;

    public static ComputeAccidentalHits create(Scope scope, Operand<Long> trueClasses, Operand<Long> sampledCandidates, Long numTrue, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder("ComputeAccidentalHits", scope.makeOpName("ComputeAccidentalHits"));
        opBuilder.addInput(trueClasses.asOutput());
        opBuilder.addInput(sampledCandidates.asOutput());
        opBuilder = scope.applyControlDependencies(opBuilder);
        opBuilder.setAttr("num_true", numTrue);
        if (options != null) {
            for (Options opts : options) {
                if (opts.seed != null) {
                    opBuilder.setAttr("seed", opts.seed);
                }
                if (opts.seed2 == null) continue;
                opBuilder.setAttr("seed2", opts.seed2);
            }
        }
        return new ComputeAccidentalHits(opBuilder.build());
    }

    public static Options seed(Long seed) {
        return new Options().seed(seed);
    }

    public static Options seed2(Long seed2) {
        return new Options().seed2(seed2);
    }

    public Output<Integer> indices() {
        return this.indices;
    }

    public Output<Long> ids() {
        return this.ids;
    }

    public Output<Float> weights() {
        return this.weights;
    }

    private ComputeAccidentalHits(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.indices = operation.output(outputIdx++);
        this.ids = operation.output(outputIdx++);
        this.weights = operation.output(outputIdx++);
    }

    public static class Options {
        private Long seed;
        private Long seed2;

        public Options seed(Long seed) {
            this.seed = seed;
            return this;
        }

        public Options seed2(Long seed2) {
            this.seed2 = seed2;
            return this;
        }

        private Options() {
        }
    }
}

